/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.NotificationChannelServiceSettings;
import com.google.cloud.monitoring.v3.stub.NotificationChannelServiceStub;
import com.google.cloud.monitoring.v3.stub.NotificationChannelServiceStubSettings;
import com.google.monitoring.v3.CreateNotificationChannelRequest;
import com.google.monitoring.v3.DeleteNotificationChannelRequest;
import com.google.monitoring.v3.GetNotificationChannelDescriptorRequest;
import com.google.monitoring.v3.GetNotificationChannelRequest;
import com.google.monitoring.v3.GetNotificationChannelVerificationCodeRequest;
import com.google.monitoring.v3.GetNotificationChannelVerificationCodeResponse;
import com.google.monitoring.v3.ListNotificationChannelDescriptorsRequest;
import com.google.monitoring.v3.ListNotificationChannelDescriptorsResponse;
import com.google.monitoring.v3.ListNotificationChannelsRequest;
import com.google.monitoring.v3.ListNotificationChannelsResponse;
import com.google.monitoring.v3.NotificationChannel;
import com.google.monitoring.v3.NotificationChannelDescriptor;
import com.google.monitoring.v3.NotificationChannelDescriptorName;
import com.google.monitoring.v3.NotificationChannelName;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.SendNotificationChannelVerificationCodeRequest;
import com.google.monitoring.v3.UpdateNotificationChannelRequest;
import com.google.monitoring.v3.VerifyNotificationChannelRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.shaded.com.google.common.util.concurrent.MoreExecutors;

public class NotificationChannelServiceClient
implements BackgroundResource {
    private final NotificationChannelServiceSettings settings;
    private final NotificationChannelServiceStub stub;

    public static final NotificationChannelServiceClient create() throws IOException {
        return NotificationChannelServiceClient.create(NotificationChannelServiceSettings.newBuilder().build());
    }

    public static final NotificationChannelServiceClient create(NotificationChannelServiceSettings settings) throws IOException {
        return new NotificationChannelServiceClient(settings);
    }

    public static final NotificationChannelServiceClient create(NotificationChannelServiceStub stub) {
        return new NotificationChannelServiceClient(stub);
    }

    protected NotificationChannelServiceClient(NotificationChannelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NotificationChannelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected NotificationChannelServiceClient(NotificationChannelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NotificationChannelServiceSettings getSettings() {
        return this.settings;
    }

    public NotificationChannelServiceStub getStub() {
        return this.stub;
    }

    public final ListNotificationChannelDescriptorsPagedResponse listNotificationChannelDescriptors(ResourceName name) {
        ListNotificationChannelDescriptorsRequest request = ListNotificationChannelDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannelDescriptors(request);
    }

    public final ListNotificationChannelDescriptorsPagedResponse listNotificationChannelDescriptors(OrganizationName name) {
        ListNotificationChannelDescriptorsRequest request = ListNotificationChannelDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannelDescriptors(request);
    }

    public final ListNotificationChannelDescriptorsPagedResponse listNotificationChannelDescriptors(ProjectName name) {
        ListNotificationChannelDescriptorsRequest request = ListNotificationChannelDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannelDescriptors(request);
    }

    public final ListNotificationChannelDescriptorsPagedResponse listNotificationChannelDescriptors(String name) {
        ListNotificationChannelDescriptorsRequest request = ListNotificationChannelDescriptorsRequest.newBuilder().setName(name).build();
        return this.listNotificationChannelDescriptors(request);
    }

    public final ListNotificationChannelDescriptorsPagedResponse listNotificationChannelDescriptors(ListNotificationChannelDescriptorsRequest request) {
        return this.listNotificationChannelDescriptorsPagedCallable().call(request);
    }

    public final UnaryCallable<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsPagedResponse> listNotificationChannelDescriptorsPagedCallable() {
        return this.stub.listNotificationChannelDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse> listNotificationChannelDescriptorsCallable() {
        return this.stub.listNotificationChannelDescriptorsCallable();
    }

    public final NotificationChannelDescriptor getNotificationChannelDescriptor(NotificationChannelDescriptorName name) {
        GetNotificationChannelDescriptorRequest request = GetNotificationChannelDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationChannelDescriptor(request);
    }

    public final NotificationChannelDescriptor getNotificationChannelDescriptor(String name) {
        GetNotificationChannelDescriptorRequest request = GetNotificationChannelDescriptorRequest.newBuilder().setName(name).build();
        return this.getNotificationChannelDescriptor(request);
    }

    public final NotificationChannelDescriptor getNotificationChannelDescriptor(GetNotificationChannelDescriptorRequest request) {
        return this.getNotificationChannelDescriptorCallable().call(request);
    }

    public final UnaryCallable<GetNotificationChannelDescriptorRequest, NotificationChannelDescriptor> getNotificationChannelDescriptorCallable() {
        return this.stub.getNotificationChannelDescriptorCallable();
    }

    public final ListNotificationChannelsPagedResponse listNotificationChannels(ResourceName name) {
        ListNotificationChannelsRequest request = ListNotificationChannelsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannels(request);
    }

    public final ListNotificationChannelsPagedResponse listNotificationChannels(OrganizationName name) {
        ListNotificationChannelsRequest request = ListNotificationChannelsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannels(request);
    }

    public final ListNotificationChannelsPagedResponse listNotificationChannels(ProjectName name) {
        ListNotificationChannelsRequest request = ListNotificationChannelsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listNotificationChannels(request);
    }

    public final ListNotificationChannelsPagedResponse listNotificationChannels(String name) {
        ListNotificationChannelsRequest request = ListNotificationChannelsRequest.newBuilder().setName(name).build();
        return this.listNotificationChannels(request);
    }

    public final ListNotificationChannelsPagedResponse listNotificationChannels(ListNotificationChannelsRequest request) {
        return this.listNotificationChannelsPagedCallable().call(request);
    }

    public final UnaryCallable<ListNotificationChannelsRequest, ListNotificationChannelsPagedResponse> listNotificationChannelsPagedCallable() {
        return this.stub.listNotificationChannelsPagedCallable();
    }

    public final UnaryCallable<ListNotificationChannelsRequest, ListNotificationChannelsResponse> listNotificationChannelsCallable() {
        return this.stub.listNotificationChannelsCallable();
    }

    public final NotificationChannel getNotificationChannel(NotificationChannelName name) {
        GetNotificationChannelRequest request = GetNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationChannel(request);
    }

    public final NotificationChannel getNotificationChannel(String name) {
        GetNotificationChannelRequest request = GetNotificationChannelRequest.newBuilder().setName(name).build();
        return this.getNotificationChannel(request);
    }

    public final NotificationChannel getNotificationChannel(GetNotificationChannelRequest request) {
        return this.getNotificationChannelCallable().call(request);
    }

    public final UnaryCallable<GetNotificationChannelRequest, NotificationChannel> getNotificationChannelCallable() {
        return this.stub.getNotificationChannelCallable();
    }

    public final NotificationChannel createNotificationChannel(ResourceName name, NotificationChannel notificationChannel) {
        CreateNotificationChannelRequest request = CreateNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).setNotificationChannel(notificationChannel).build();
        return this.createNotificationChannel(request);
    }

    public final NotificationChannel createNotificationChannel(OrganizationName name, NotificationChannel notificationChannel) {
        CreateNotificationChannelRequest request = CreateNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).setNotificationChannel(notificationChannel).build();
        return this.createNotificationChannel(request);
    }

    public final NotificationChannel createNotificationChannel(ProjectName name, NotificationChannel notificationChannel) {
        CreateNotificationChannelRequest request = CreateNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).setNotificationChannel(notificationChannel).build();
        return this.createNotificationChannel(request);
    }

    public final NotificationChannel createNotificationChannel(String name, NotificationChannel notificationChannel) {
        CreateNotificationChannelRequest request = CreateNotificationChannelRequest.newBuilder().setName(name).setNotificationChannel(notificationChannel).build();
        return this.createNotificationChannel(request);
    }

    public final NotificationChannel createNotificationChannel(CreateNotificationChannelRequest request) {
        return this.createNotificationChannelCallable().call(request);
    }

    public final UnaryCallable<CreateNotificationChannelRequest, NotificationChannel> createNotificationChannelCallable() {
        return this.stub.createNotificationChannelCallable();
    }

    public final NotificationChannel updateNotificationChannel(FieldMask updateMask, NotificationChannel notificationChannel) {
        UpdateNotificationChannelRequest request = UpdateNotificationChannelRequest.newBuilder().setUpdateMask(updateMask).setNotificationChannel(notificationChannel).build();
        return this.updateNotificationChannel(request);
    }

    public final NotificationChannel updateNotificationChannel(UpdateNotificationChannelRequest request) {
        return this.updateNotificationChannelCallable().call(request);
    }

    public final UnaryCallable<UpdateNotificationChannelRequest, NotificationChannel> updateNotificationChannelCallable() {
        return this.stub.updateNotificationChannelCallable();
    }

    public final void deleteNotificationChannel(NotificationChannelName name, boolean force) {
        DeleteNotificationChannelRequest request = DeleteNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).setForce(force).build();
        this.deleteNotificationChannel(request);
    }

    public final void deleteNotificationChannel(String name, boolean force) {
        DeleteNotificationChannelRequest request = DeleteNotificationChannelRequest.newBuilder().setName(name).setForce(force).build();
        this.deleteNotificationChannel(request);
    }

    public final void deleteNotificationChannel(DeleteNotificationChannelRequest request) {
        this.deleteNotificationChannelCallable().call(request);
    }

    public final UnaryCallable<DeleteNotificationChannelRequest, Empty> deleteNotificationChannelCallable() {
        return this.stub.deleteNotificationChannelCallable();
    }

    public final void sendNotificationChannelVerificationCode(NotificationChannelName name) {
        SendNotificationChannelVerificationCodeRequest request = SendNotificationChannelVerificationCodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.sendNotificationChannelVerificationCode(request);
    }

    public final void sendNotificationChannelVerificationCode(String name) {
        SendNotificationChannelVerificationCodeRequest request = SendNotificationChannelVerificationCodeRequest.newBuilder().setName(name).build();
        this.sendNotificationChannelVerificationCode(request);
    }

    public final void sendNotificationChannelVerificationCode(SendNotificationChannelVerificationCodeRequest request) {
        this.sendNotificationChannelVerificationCodeCallable().call(request);
    }

    public final UnaryCallable<SendNotificationChannelVerificationCodeRequest, Empty> sendNotificationChannelVerificationCodeCallable() {
        return this.stub.sendNotificationChannelVerificationCodeCallable();
    }

    public final GetNotificationChannelVerificationCodeResponse getNotificationChannelVerificationCode(NotificationChannelName name) {
        GetNotificationChannelVerificationCodeRequest request = GetNotificationChannelVerificationCodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationChannelVerificationCode(request);
    }

    public final GetNotificationChannelVerificationCodeResponse getNotificationChannelVerificationCode(String name) {
        GetNotificationChannelVerificationCodeRequest request = GetNotificationChannelVerificationCodeRequest.newBuilder().setName(name).build();
        return this.getNotificationChannelVerificationCode(request);
    }

    public final GetNotificationChannelVerificationCodeResponse getNotificationChannelVerificationCode(GetNotificationChannelVerificationCodeRequest request) {
        return this.getNotificationChannelVerificationCodeCallable().call(request);
    }

    public final UnaryCallable<GetNotificationChannelVerificationCodeRequest, GetNotificationChannelVerificationCodeResponse> getNotificationChannelVerificationCodeCallable() {
        return this.stub.getNotificationChannelVerificationCodeCallable();
    }

    public final NotificationChannel verifyNotificationChannel(NotificationChannelName name, String code) {
        VerifyNotificationChannelRequest request = VerifyNotificationChannelRequest.newBuilder().setName(name == null ? null : name.toString()).setCode(code).build();
        return this.verifyNotificationChannel(request);
    }

    public final NotificationChannel verifyNotificationChannel(String name, String code) {
        VerifyNotificationChannelRequest request = VerifyNotificationChannelRequest.newBuilder().setName(name).setCode(code).build();
        return this.verifyNotificationChannel(request);
    }

    public final NotificationChannel verifyNotificationChannel(VerifyNotificationChannelRequest request) {
        return this.verifyNotificationChannelCallable().call(request);
    }

    public final UnaryCallable<VerifyNotificationChannelRequest, NotificationChannel> verifyNotificationChannelCallable() {
        return this.stub.verifyNotificationChannelCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNotificationChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel, ListNotificationChannelsPage, ListNotificationChannelsFixedSizeCollection> {
        private ListNotificationChannelsFixedSizeCollection(List<ListNotificationChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationChannelsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationChannelsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListNotificationChannelsFixedSizeCollection createCollection(List<ListNotificationChannelsPage> pages, int collectionSize) {
            return new ListNotificationChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationChannelsPage
    extends AbstractPage<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel, ListNotificationChannelsPage> {
        private ListNotificationChannelsPage(PageContext<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel> context, ListNotificationChannelsResponse response) {
            super(context, response);
        }

        private static ListNotificationChannelsPage createEmptyPage() {
            return new ListNotificationChannelsPage(null, null);
        }

        @Override
        protected ListNotificationChannelsPage createPage(PageContext<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel> context, ListNotificationChannelsResponse response) {
            return new ListNotificationChannelsPage(context, response);
        }

        @Override
        public ApiFuture<ListNotificationChannelsPage> createPageAsync(PageContext<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel> context, ApiFuture<ListNotificationChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotificationChannelsPagedResponse
    extends AbstractPagedListResponse<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel, ListNotificationChannelsPage, ListNotificationChannelsFixedSizeCollection> {
        public static ApiFuture<ListNotificationChannelsPagedResponse> createAsync(PageContext<ListNotificationChannelsRequest, ListNotificationChannelsResponse, NotificationChannel> context, ApiFuture<ListNotificationChannelsResponse> futureResponse) {
            ApiFuture<ListNotificationChannelsPage> futurePage = ListNotificationChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotificationChannelsPagedResponse((ListNotificationChannelsPage)input), MoreExecutors.directExecutor());
        }

        private ListNotificationChannelsPagedResponse(ListNotificationChannelsPage page) {
            super(page, ListNotificationChannelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotificationChannelDescriptorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor, ListNotificationChannelDescriptorsPage, ListNotificationChannelDescriptorsFixedSizeCollection> {
        private ListNotificationChannelDescriptorsFixedSizeCollection(List<ListNotificationChannelDescriptorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationChannelDescriptorsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationChannelDescriptorsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListNotificationChannelDescriptorsFixedSizeCollection createCollection(List<ListNotificationChannelDescriptorsPage> pages, int collectionSize) {
            return new ListNotificationChannelDescriptorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationChannelDescriptorsPage
    extends AbstractPage<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor, ListNotificationChannelDescriptorsPage> {
        private ListNotificationChannelDescriptorsPage(PageContext<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor> context, ListNotificationChannelDescriptorsResponse response) {
            super(context, response);
        }

        private static ListNotificationChannelDescriptorsPage createEmptyPage() {
            return new ListNotificationChannelDescriptorsPage(null, null);
        }

        @Override
        protected ListNotificationChannelDescriptorsPage createPage(PageContext<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor> context, ListNotificationChannelDescriptorsResponse response) {
            return new ListNotificationChannelDescriptorsPage(context, response);
        }

        @Override
        public ApiFuture<ListNotificationChannelDescriptorsPage> createPageAsync(PageContext<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor> context, ApiFuture<ListNotificationChannelDescriptorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotificationChannelDescriptorsPagedResponse
    extends AbstractPagedListResponse<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor, ListNotificationChannelDescriptorsPage, ListNotificationChannelDescriptorsFixedSizeCollection> {
        public static ApiFuture<ListNotificationChannelDescriptorsPagedResponse> createAsync(PageContext<ListNotificationChannelDescriptorsRequest, ListNotificationChannelDescriptorsResponse, NotificationChannelDescriptor> context, ApiFuture<ListNotificationChannelDescriptorsResponse> futureResponse) {
            ApiFuture<ListNotificationChannelDescriptorsPage> futurePage = ListNotificationChannelDescriptorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNotificationChannelDescriptorsPagedResponse((ListNotificationChannelDescriptorsPage)input), MoreExecutors.directExecutor());
        }

        private ListNotificationChannelDescriptorsPagedResponse(ListNotificationChannelDescriptorsPage page) {
            super(page, ListNotificationChannelDescriptorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

