/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.storage.v2.WriteObjectRequest;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

final class WriteCtx<RequestFactoryT extends WriteObjectRequestBuilderFactory> {
    private final RequestFactoryT requestFactory;
    private final AtomicLong totalSentBytes;
    private final AtomicLong confirmedBytes;
    private final AtomicReference<Crc32cValue.Crc32cLengthKnown> cumulativeCrc32c;

    WriteCtx(RequestFactoryT requestFactory) {
        this.requestFactory = requestFactory;
        this.totalSentBytes = new AtomicLong(0L);
        this.confirmedBytes = new AtomicLong(0L);
        this.cumulativeCrc32c = new AtomicReference();
    }

    public RequestFactoryT getRequestFactory() {
        return this.requestFactory;
    }

    public WriteObjectRequest.Builder newRequestBuilder() {
        return this.requestFactory.newBuilder();
    }

    public AtomicLong getTotalSentBytes() {
        return this.totalSentBytes;
    }

    public AtomicLong getConfirmedBytes() {
        return this.confirmedBytes;
    }

    public AtomicReference<Crc32cValue.Crc32cLengthKnown> getCumulativeCrc32c() {
        return this.cumulativeCrc32c;
    }

    boolean isDirty() {
        return this.confirmedBytes.get() == this.totalSentBytes.get();
    }

    public String toString() {
        return "ServerState{requestFactory=" + this.requestFactory + ", totalSentBytes=" + this.totalSentBytes + ", confirmedBytes=" + this.confirmedBytes + ", totalSentCrc32c=" + this.cumulativeCrc32c + '}';
    }

    static interface WriteObjectRequestBuilderFactory {
        public WriteObjectRequest.Builder newBuilder();

        public @Nullable String bucketName();

        public static SimpleWriteObjectRequestBuilderFactory simple(WriteObjectRequest req) {
            return new SimpleWriteObjectRequestBuilderFactory(req);
        }
    }

    static final class SimpleWriteObjectRequestBuilderFactory
    implements WriteObjectRequestBuilderFactory {
        private final WriteObjectRequest req;

        private SimpleWriteObjectRequestBuilderFactory(WriteObjectRequest req) {
            this.req = req;
        }

        @Override
        public WriteObjectRequest.Builder newBuilder() {
            return this.req.toBuilder();
        }

        @Override
        public @Nullable String bucketName() {
            if (this.req.hasWriteObjectSpec() && this.req.getWriteObjectSpec().hasResource()) {
                return this.req.getWriteObjectSpec().getResource().getBucket();
            }
            return null;
        }

        public String toString() {
            return "SimpleWriteObjectRequestBuilderFactory{req=" + StorageV2ProtoUtils.fmtProto(this.req) + '}';
        }
    }
}

