/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageRetryHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.base.Strings;
import org.apache.pinot.shaded.com.google.common.collect.Lists;

@ThreadSafe
final class CloudStorageReadChannel
implements SeekableByteChannel {
    private final Storage gcsStorage;
    private final BlobId file;
    @VisibleForTesting
    final int maxChannelReopens;
    final int maxRetries;
    final Storage.BlobSourceOption[] blobSourceOptions;
    final CloudStorageConfiguration config;
    private ReadChannel channel;
    private long position;
    private long size;
    private Long generation;

    @CheckReturnValue
    static CloudStorageReadChannel create(Storage gcsStorage, BlobId file, long position, int maxChannelReopens, CloudStorageConfiguration config, @Nullable String userProject, Storage.BlobSourceOption ... blobSourceOptions) throws IOException {
        return new CloudStorageReadChannel(gcsStorage, file, position, maxChannelReopens, config, userProject, blobSourceOptions);
    }

    private CloudStorageReadChannel(Storage gcsStorage, BlobId file, long position, int maxChannelReopens, CloudStorageConfiguration config, @Nullable String userProject, Storage.BlobSourceOption ... blobSourceOptions) throws IOException {
        this.gcsStorage = gcsStorage;
        this.file = file;
        this.position = position;
        this.maxChannelReopens = maxChannelReopens;
        this.maxRetries = Math.max(3, maxChannelReopens);
        this.config = config;
        this.fetchSize(gcsStorage, userProject, file);
        ArrayList<Storage.BlobSourceOption> options = Lists.newArrayList(blobSourceOptions);
        if (null != this.generation) {
            options.add(Storage.BlobSourceOption.generationMatch(this.generation));
        }
        if (!Strings.isNullOrEmpty(userProject)) {
            options.add(Storage.BlobSourceOption.userProject(userProject));
        }
        this.blobSourceOptions = options.toArray(new Storage.BlobSourceOption[options.size()]);
        this.innerOpen();
    }

    private void innerOpen() throws IOException {
        this.channel = this.gcsStorage.reader(this.file, this.blobSourceOptions);
        if (this.position > 0L) {
            this.channel.seek(this.position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            int amt;
            this.checkOpen();
            CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(this.maxRetries, this.maxChannelReopens, this.config);
            dst.mark();
            while (true) {
                try {
                    dst.reset();
                    amt = this.channel.read(dst);
                }
                catch (StorageException exs) {
                    this.handleStorageException(exs, retryHandler);
                    continue;
                }
                break;
            }
            if (amt > 0) {
                this.position += (long)amt;
                if (this.position > this.size) {
                    this.size = this.position;
                }
            }
            return amt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Preconditions.checkArgument(newPosition >= 0L);
        CloudStorageReadChannel cloudStorageReadChannel = this;
        synchronized (cloudStorageReadChannel) {
            this.checkOpen();
            if (newPosition == this.position) {
                return this;
            }
            this.channel.seek(newPosition);
            this.position = newPosition;
            return this;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private long fetchSize(Storage gcsStorage, @Nullable String userProject, BlobId file) throws IOException {
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(this.maxRetries, this.maxChannelReopens, this.config);
        while (true) {
            try {
                Blob blobInfo = Strings.isNullOrEmpty(userProject) ? gcsStorage.get(file, Storage.BlobGetOption.fields(Storage.BlobField.GENERATION, Storage.BlobField.SIZE)) : gcsStorage.get(file, Storage.BlobGetOption.fields(Storage.BlobField.GENERATION, Storage.BlobField.SIZE), Storage.BlobGetOption.userProject(userProject));
                if (blobInfo == null) {
                    throw new NoSuchFileException(String.format("gs://%s/%s", file.getBucket(), file.getName()));
                }
                this.generation = blobInfo.getGeneration();
                this.size = blobInfo.getSize();
                return this.size;
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            break;
        }
    }

    private void handleStorageException(StorageException exs, CloudStorageRetryHandler retryHandler) throws IOException {
        boolean shouldReopen = retryHandler.handleStorageException(exs);
        if (shouldReopen) {
            this.innerOpen();
        }
    }
}

