/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;

public class ServiceLevelObjectiveName
implements ResourceName {
    private static final PathTemplate PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE = PathTemplate.createWithoutUrlEncoding("projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private static final PathTemplate ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private static final PathTemplate FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE = PathTemplate.createWithoutUrlEncoding("folders/{folder}/services/{service}/serviceLevelObjectives/{service_level_objective}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String service;
    private final String serviceLevelObjective;
    private final String organization;
    private final String folder;

    @Deprecated
    protected ServiceLevelObjectiveName() {
        this.project = null;
        this.service = null;
        this.serviceLevelObjective = null;
        this.organization = null;
        this.folder = null;
    }

    private ServiceLevelObjectiveName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.serviceLevelObjective = Preconditions.checkNotNull(builder.getServiceLevelObjective());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE;
    }

    private ServiceLevelObjectiveName(OrganizationServiceServiceLevelObjectiveBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.serviceLevelObjective = Preconditions.checkNotNull(builder.getServiceLevelObjective());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE;
    }

    private ServiceLevelObjectiveName(FolderServiceServiceLevelObjectiveBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.serviceLevelObjective = Preconditions.checkNotNull(builder.getServiceLevelObjective());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE;
    }

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getServiceLevelObjective() {
        return this.serviceLevelObjective;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectServiceServiceLevelObjectiveBuilder() {
        return new Builder();
    }

    public static OrganizationServiceServiceLevelObjectiveBuilder newOrganizationServiceServiceLevelObjectiveBuilder() {
        return new OrganizationServiceServiceLevelObjectiveBuilder();
    }

    public static FolderServiceServiceLevelObjectiveBuilder newFolderServiceServiceLevelObjectiveBuilder() {
        return new FolderServiceServiceLevelObjectiveBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceLevelObjectiveName of(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static ServiceLevelObjectiveName ofProjectServiceServiceLevelObjectiveName(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static ServiceLevelObjectiveName ofOrganizationServiceServiceLevelObjectiveName(String organization, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newOrganizationServiceServiceLevelObjectiveBuilder().setOrganization(organization).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static ServiceLevelObjectiveName ofFolderServiceServiceLevelObjectiveName(String folder, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newFolderServiceServiceLevelObjectiveBuilder().setFolder(folder).setService(service).setServiceLevelObjective(serviceLevelObjective).build();
    }

    public static String format(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static String formatProjectServiceServiceLevelObjectiveName(String project, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newBuilder().setProject(project).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static String formatOrganizationServiceServiceLevelObjectiveName(String organization, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newOrganizationServiceServiceLevelObjectiveBuilder().setOrganization(organization).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static String formatFolderServiceServiceLevelObjectiveName(String folder, String service, String serviceLevelObjective) {
        return ServiceLevelObjectiveName.newFolderServiceServiceLevelObjectiveBuilder().setFolder(folder).setService(service).setServiceLevelObjective(serviceLevelObjective).build().toString();
    }

    public static ServiceLevelObjectiveName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE.match(formattedString);
            return ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName(matchMap.get("project"), matchMap.get("service"), matchMap.get("service_level_objective"));
        }
        if (ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE.match(formattedString);
            return ServiceLevelObjectiveName.ofOrganizationServiceServiceLevelObjectiveName(matchMap.get("organization"), matchMap.get("service"), matchMap.get("service_level_objective"));
        }
        if (FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE.match(formattedString);
            return ServiceLevelObjectiveName.ofFolderServiceServiceLevelObjectiveName(matchMap.get("folder"), matchMap.get("service"), matchMap.get("service_level_objective"));
        }
        throw new ValidationException("ServiceLevelObjectiveName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServiceLevelObjectiveName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceLevelObjectiveName> list = new ArrayList<ServiceLevelObjectiveName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceLevelObjectiveName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceLevelObjectiveName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceLevelObjectiveName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString) || ORGANIZATION_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString) || FOLDER_SERVICE_SERVICE_LEVEL_OBJECTIVE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceLevelObjectiveName serviceLevelObjectiveName = this;
            synchronized (serviceLevelObjectiveName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put("service", this.service);
                    }
                    if (this.serviceLevelObjective != null) {
                        fieldMapBuilder.put("service_level_objective", this.serviceLevelObjective);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceLevelObjectiveName that = (ServiceLevelObjectiveName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.service, that.service) && Objects.equals(this.serviceLevelObjective, that.serviceLevelObjective) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.service);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.serviceLevelObjective);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderServiceServiceLevelObjectiveBuilder {
        private String folder;
        private String service;
        private String serviceLevelObjective;

        protected FolderServiceServiceLevelObjectiveBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public FolderServiceServiceLevelObjectiveBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderServiceServiceLevelObjectiveBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public FolderServiceServiceLevelObjectiveBuilder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }

    public static class OrganizationServiceServiceLevelObjectiveBuilder {
        private String organization;
        private String service;
        private String serviceLevelObjective;

        protected OrganizationServiceServiceLevelObjectiveBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public OrganizationServiceServiceLevelObjectiveBuilder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }

    public static class Builder {
        private String project;
        private String service;
        private String serviceLevelObjective;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public String getServiceLevelObjective() {
            return this.serviceLevelObjective;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setServiceLevelObjective(String serviceLevelObjective) {
            this.serviceLevelObjective = serviceLevelObjective;
            return this;
        }

        private Builder(ServiceLevelObjectiveName serviceLevelObjectiveName) {
            Preconditions.checkArgument(Objects.equals(serviceLevelObjectiveName.pathTemplate, PROJECT_SERVICE_SERVICE_LEVEL_OBJECTIVE), "toBuilder is only supported when ServiceLevelObjectiveName has the pattern of projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}");
            this.project = serviceLevelObjectiveName.project;
            this.service = serviceLevelObjectiveName.service;
            this.serviceLevelObjective = serviceLevelObjectiveName.serviceLevelObjective;
        }

        public ServiceLevelObjectiveName build() {
            return new ServiceLevelObjectiveName(this);
        }
    }
}

