/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.metrics.dropwizard;

import com.google.auto.service.AutoService;
import java.util.function.Function;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardGauge;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardJmxReporter;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardMetricName;
import org.apache.pinot.plugin.metrics.dropwizard.DropwizardMetricsRegistry;
import org.apache.pinot.spi.annotations.metrics.MetricsFactory;
import org.apache.pinot.spi.annotations.metrics.PinotMetricsFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotJmxReporter;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

@MetricsFactory
@AutoService(value={PinotMetricsFactory.class})
public class DropwizardMetricsFactory
implements PinotMetricsFactory {
    public static final String DOMAIN_PROP = "pinot.metrics.dropwizard.domain";
    public static final String DEFAULT_DOMAIN_VALUE = "org.apache.pinot.common.metrics";
    private PinotMetricsRegistry _pinotMetricsRegistry = null;
    private String _domainName;

    public void init(PinotConfiguration metricsConfiguration) {
        this._domainName = metricsConfiguration.getProperty(DOMAIN_PROP, DEFAULT_DOMAIN_VALUE);
    }

    public PinotMetricsRegistry getPinotMetricsRegistry() {
        if (this._pinotMetricsRegistry == null) {
            this._pinotMetricsRegistry = new DropwizardMetricsRegistry();
        }
        return this._pinotMetricsRegistry;
    }

    public PinotMetricName makePinotMetricName(Class<?> klass, String name) {
        return new DropwizardMetricName(klass, name);
    }

    public <T> PinotGauge<T> makePinotGauge(Function<Void, T> condition) {
        return new DropwizardGauge<T>(condition);
    }

    public PinotJmxReporter makePinotJmxReporter(PinotMetricsRegistry metricsRegistry) {
        return new DropwizardJmxReporter(metricsRegistry, this._domainName);
    }

    public String getMetricsFactoryName() {
        return "Dropwizard";
    }
}

