/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.refreshsegment;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderRegistry;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.Obfuscator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshSegmentTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshSegmentTaskExecutor.class);
    private long _taskStartTime;

    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Refreshing segment: " + String.valueOf(indexDir)));
        this._taskStartTime = System.currentTimeMillis();
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String segmentName = (String)configs.get("segmentName");
        String taskType = pinotTaskConfig.getTaskType();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)Obfuscator.DEFAULT.toJsonString((Object)configs));
        }
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        Schema schema = this.getSchema(tableNameWithType);
        IndexLoadingConfig indexLoadingConfig = new IndexLoadingConfig(tableConfig, schema);
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        PinotConfiguration segmentDirectoryConfigs = indexLoadingConfig.getSegmentDirectoryConfigs();
        SegmentDirectoryLoaderContext segmentLoaderContext = new SegmentDirectoryLoaderContext.Builder().setTableConfig(indexLoadingConfig.getTableConfig()).setSchema(schema).setInstanceId(indexLoadingConfig.getInstanceId()).setSegmentName(segmentMetadata.getName()).setSegmentCrc(segmentMetadata.getCrc()).setSegmentDirectoryConfigs(segmentDirectoryConfigs).build();
        SegmentDirectory segmentDirectory = SegmentDirectoryLoaderRegistry.getDefaultSegmentDirectoryLoader().load(indexDir.toURI(), segmentLoaderContext);
        boolean needPreprocess = ImmutableSegmentLoader.needPreprocess((SegmentDirectory)segmentDirectory, (IndexLoadingConfig)indexLoadingConfig);
        RefreshSegmentTaskExecutor.closeSegmentDirectoryQuietly(segmentDirectory);
        HashSet<String> refreshColumnSet = new HashSet<String>();
        for (FieldSpec fieldSpecInSchema : schema.getAllFieldSpecs()) {
            if (fieldSpecInSchema.isVirtualColumn()) continue;
            String column = fieldSpecInSchema.getName();
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata != null) {
                FieldSpec.DataType dataTypeInSchema;
                FieldSpec fieldSpecInSegment = columnMetadata.getFieldSpec();
                FieldSpec.DataType dataTypeInSegment = fieldSpecInSegment.getDataType();
                if (dataTypeInSegment == (dataTypeInSchema = fieldSpecInSchema.getDataType())) continue;
                refreshColumnSet.add(column);
                continue;
            }
            refreshColumnSet.add(column);
        }
        if (!needPreprocess && refreshColumnSet.isEmpty()) {
            LOGGER.info("Skipping segment={}, table={} as it is up-to-date with new table/schema", (Object)segmentName, (Object)tableNameWithType);
            return new SegmentConversionResult.Builder().setTableNameWithType(tableNameWithType).setFile(indexDir).setSegmentName(segmentName).build();
        }
        try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();){
            recordReader.init(indexDir, null, null);
            SegmentGeneratorConfig config = RefreshSegmentTaskExecutor.getSegmentGeneratorConfig(workingDir, tableConfig, segmentMetadata, segmentName, this.getSchema(tableNameWithType));
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            driver.init(config, (RecordReader)recordReader);
            driver.build();
            this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Segment processing stats - incomplete rows:" + driver.getIncompleteRowsFound() + ", dropped rows:" + driver.getSkippedRowsFound() + ", sanitized rows:" + driver.getSanitizedRowsFound()));
        }
        File refreshedSegmentFile = new File(workingDir, segmentName);
        SegmentConversionResult result = new SegmentConversionResult.Builder().setFile(refreshedSegmentFile).setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        long endMillis = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, Obfuscator.DEFAULT.toJsonString((Object)configs), endMillis - this._taskStartTime});
        }
        return result;
    }

    private static SegmentGeneratorConfig getSegmentGeneratorConfig(File workingDir, TableConfig tableConfig, SegmentMetadataImpl segmentMetadata, String segmentName, Schema schema) {
        tableConfig.getIndexingConfig().setCreateInvertedIndexDuringSegmentGeneration(true);
        SegmentGeneratorConfig config = new SegmentGeneratorConfig(tableConfig, schema);
        config.setOutDir(workingDir.getPath());
        config.setSegmentName(segmentName);
        config.setCreationTime(String.valueOf(segmentMetadata.getIndexCreationTime()));
        if (segmentMetadata.getTimeInterval() != null) {
            config.setTimeColumnName(tableConfig.getValidationConfig().getTimeColumnName());
            config.setStartTime(Long.toString(segmentMetadata.getStartTime()));
            config.setEndTime(Long.toString(segmentMetadata.getEndTime()));
            config.setSegmentTimeUnit(segmentMetadata.getTimeUnit());
        }
        return config;
    }

    private static void closeSegmentDirectoryQuietly(SegmentDirectory segmentDirectory) {
        if (segmentDirectory != null) {
            try {
                segmentDirectory.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close SegmentDirectory due to error: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("RefreshSegmentTask.time", MinionTaskUtils.toUTCString(this._taskStartTime)));
    }
}

