/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.util.DateTimeRfc1123;
import java.io.IOException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class DateTimeRfc1123Serializer
extends JsonSerializer<DateTimeRfc1123> {
    DateTimeRfc1123Serializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(DateTimeRfc1123.class, new DateTimeRfc1123Serializer());
        return module;
    }

    @Override
    public void serialize(DateTimeRfc1123 value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(value.getDateTime().toInstant().toEpochMilli());
        } else {
            jgen.writeString(value.toString());
        }
    }
}

