/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.WindowsCredentialApi;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.win32.W32APIOptions;
import java.nio.charset.StandardCharsets;

public class WindowsCredentialAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(WindowsCredentialAccessor.class);
    private WindowsCredentialApi accessor = Native.load("Advapi32", WindowsCredentialApi.class, W32APIOptions.UNICODE_OPTIONS);
    private String serviceName;
    private String accountName;

    public WindowsCredentialAccessor(String serviceName, String accountName) {
        this.serviceName = serviceName;
        this.accountName = accountName;
    }

    public String read() {
        WindowsCredentialApi.PCREDENTIAL pcredential = new WindowsCredentialApi.PCREDENTIAL();
        try {
            boolean readOk = this.accessor.CredRead(String.format("%s/%s", this.serviceName, this.accountName), 1, 0, pcredential);
            if (!readOk) {
                int rc = Kernel32.INSTANCE.GetLastError();
                String errMsg = Kernel32Util.formatMessage(rc);
                throw LOGGER.logExceptionAsError(new RuntimeException(errMsg));
            }
            WindowsCredentialApi.CREDENTIAL credential = new WindowsCredentialApi.CREDENTIAL(pcredential.credential);
            byte[] secretBytes = credential.CredentialBlob.getByteArray(0L, credential.CredentialBlobSize);
            String string = new String(secretBytes, StandardCharsets.UTF_8);
            return string;
        }
        catch (LastErrorException e) {
            int errorCode = e.getErrorCode();
            String errMsg = Kernel32Util.formatMessage(errorCode);
            throw LOGGER.logExceptionAsError(new RuntimeException(errMsg));
        }
        finally {
            if (pcredential.credential != null) {
                this.accessor.CredFree(pcredential.credential);
            }
        }
    }
}

