/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;

final class IdleTimeoutHandler
extends IdleStateHandler {
    IdleTimeoutHandler(long idleTimeout) {
        super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
        if (evt.state() == IdleState.READER_IDLE) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Connection was idle for [{}ms], as per configuration the connection will be closed."), this.getReaderIdleTimeInMillis());
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    static void addIdleTimeoutHandler(ChannelPipeline pipeline, @Nullable Duration idleTimeout) {
        if (idleTimeout != null && pipeline.get("reactor.left.idleTimeoutHandler") == null) {
            String baseName = null;
            if (pipeline.get("reactor.left.httpCodec") != null) {
                baseName = "reactor.left.httpCodec";
            } else {
                HttpServerUpgradeHandler httpServerUpgradeHandler = pipeline.get(HttpServerUpgradeHandler.class);
                if (httpServerUpgradeHandler != null) {
                    baseName = pipeline.context(httpServerUpgradeHandler).name();
                } else {
                    HttpServerCodec httpServerCodec = pipeline.get(HttpServerCodec.class);
                    if (httpServerCodec != null) {
                        baseName = pipeline.context(httpServerCodec).name();
                    }
                }
            }
            pipeline.addAfter(baseName, "reactor.left.idleTimeoutHandler", new IdleTimeoutHandler(idleTimeout.toMillis()));
        }
    }

    static void removeIdleTimeoutHandler(ChannelPipeline pipeline) {
        if (pipeline.get("reactor.left.idleTimeoutHandler") != null) {
            pipeline.remove("reactor.left.idleTimeoutHandler");
        }
    }
}

