/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

public class Tokenizer {
    private final String _query;

    public Tokenizer(String query) {
        this._query = query;
    }

    public List<List<String>> tokenize() {
        String[] pipelines = this._query.split("\\|");
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (String pipeline : pipelines) {
            String command = pipeline.trim().substring(0, pipeline.indexOf("{"));
            if (command.equals("fetch")) {
                result.add(this.consumeFetch(pipeline.trim()));
                continue;
            }
            result.add(this.consumeGeneric(pipeline.trim()));
        }
        return result;
    }

    private List<String> consumeFetch(String pipeline) {
        pipeline = pipeline.trim();
        String command = pipeline.substring(0, 5);
        Preconditions.checkState(command.equals("fetch"), "Invalid command: %s", (Object)command);
        pipeline = pipeline.substring(5).trim();
        int start = pipeline.indexOf("{");
        int end = pipeline.indexOf("}");
        String args = pipeline.substring(start + 1, end);
        ArrayList<String> result = new ArrayList<String>();
        result.add("fetch");
        int indexOfEquals = args.indexOf("=");
        while (indexOfEquals != -1) {
            args = args.strip();
            int equalIndex = args.indexOf("=");
            int indexOfQuotes = args.indexOf("\"");
            int lastQuote = indexOfQuotes + 1 + args.substring(indexOfQuotes + 1).indexOf("\"");
            String key = args.substring(0, equalIndex);
            String value = args.substring(indexOfQuotes + 1, lastQuote);
            args = args.substring(lastQuote + 1);
            result.add(key);
            result.add(value);
            if (args.strip().startsWith(",")) {
                args = args.strip().substring(1);
            }
            indexOfEquals = args.indexOf("=");
        }
        return result;
    }

    private List<String> consumeGeneric(String pipeline) {
        ArrayList<String> result = new ArrayList<String>();
        int indexOfOpenBracket = pipeline.indexOf("{");
        int indexOfClosedBracket = pipeline.indexOf("}");
        result.add(pipeline.substring(0, indexOfOpenBracket));
        String arg = pipeline.substring(indexOfOpenBracket + 1, indexOfClosedBracket);
        if (!arg.isEmpty()) {
            result.add(arg);
        }
        return result;
    }
}

