/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.testclient.PerfClientUtils;

public abstract class PerformanceBaseArguments {
    @Parameter(names={"-h", "--help"}, description="Help message", help=true)
    boolean help;
    @Parameter(names={"-cf", "--conf-file"}, description="Configuration file")
    public String confFile;
    @Parameter(names={"-u", "--service-url"}, description="Pulsar Service URL")
    public String serviceURL;
    @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name")
    public String authPluginClassName;
    @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}\".")
    public String authParams;
    @Parameter(names={"--trust-cert-file"}, description="Path for the trusted TLS certificate file")
    public String tlsTrustCertsFilePath = "";
    @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure TLS connection")
    public Boolean tlsAllowInsecureConnection = null;
    @Parameter(names={"--tls-enable-hostname-verification"}, description="Enable TLS hostname verification")
    public Boolean tlsHostnameVerificationEnable = null;
    @Parameter(names={"-c", "--max-connections"}, description="Max number of TCP connections to a single broker")
    public int maxConnections = 1;
    @Parameter(names={"-i", "--stats-interval-seconds"}, description="Statistics Interval Seconds. If 0, statistics will be disabled")
    public long statsIntervalSeconds = 0L;
    @Parameter(names={"-ioThreads", "--num-io-threads"}, description="Set the number of threads to be used for handling connections to brokers. The default value is 1.")
    public int ioThreads = 1;
    @Parameter(names={"-bw", "--busy-wait"}, description="Enable Busy-Wait on the Pulsar client")
    public boolean enableBusyWait = false;
    @Parameter(names={"--listener-name"}, description="Listener name for the broker.")
    public String listenerName = null;
    @Parameter(names={"-lt", "--num-listener-threads"}, description="Set the number of threads to be used for message listeners")
    public int listenerThreads = 1;
    @Parameter(names={"-mlr", "--max-lookup-request"}, description="Maximum number of lookup requests allowed on each broker connection to prevent overloading a broker")
    public int maxLookupRequest = 50000;
    @Parameter(names={"--proxy-url"}, description="Proxy-server URL to which to connect.")
    String proxyServiceURL = null;
    @Parameter(names={"--proxy-protocol"}, description="Proxy protocol to select type of routing at proxy.")
    ProxyProtocol proxyProtocol = null;

    public abstract void fillArgumentsFromProperties(Properties var1);

    public void fillArgumentsFromProperties() {
        if (this.confFile == null) {
            return;
        }
        Properties prop = new Properties(System.getProperties());
        try (FileInputStream fis = new FileInputStream(this.confFile);){
            prop.load(fis);
        }
        if (this.serviceURL == null) {
            this.serviceURL = prop.getProperty("brokerServiceUrl");
        }
        if (this.serviceURL == null) {
            this.serviceURL = prop.getProperty("webServiceUrl");
        }
        if (this.serviceURL == null) {
            this.serviceURL = prop.getProperty("serviceUrl", "http://localhost:8080/");
        }
        if (this.authPluginClassName == null) {
            this.authPluginClassName = prop.getProperty("authPlugin", null);
        }
        if (this.authParams == null) {
            this.authParams = prop.getProperty("authParams", null);
        }
        if (StringUtils.isBlank((CharSequence)this.tlsTrustCertsFilePath)) {
            this.tlsTrustCertsFilePath = prop.getProperty("tlsTrustCertsFilePath", "");
        }
        if (this.tlsAllowInsecureConnection == null) {
            this.tlsAllowInsecureConnection = Boolean.parseBoolean(prop.getProperty("tlsAllowInsecureConnection", ""));
        }
        if (this.tlsHostnameVerificationEnable == null) {
            this.tlsHostnameVerificationEnable = Boolean.parseBoolean(prop.getProperty("tlsEnableHostnameVerification", ""));
        }
        if (this.proxyServiceURL == null) {
            this.proxyServiceURL = StringUtils.trimToNull((String)prop.getProperty("proxyServiceUrl"));
        }
        if (this.proxyProtocol == null) {
            String proxyProtocolString = null;
            try {
                proxyProtocolString = StringUtils.trimToNull((String)prop.getProperty("proxyProtocol"));
                if (proxyProtocolString != null) {
                    this.proxyProtocol = ProxyProtocol.valueOf((String)proxyProtocolString.toUpperCase());
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("Incorrect proxyProtocol name '" + proxyProtocolString + "'");
                e.printStackTrace();
                PerfClientUtils.exit(1);
            }
        }
        this.fillArgumentsFromProperties(prop);
    }
}

