/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Table;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Merge
extends Statement {
    private final Table table;
    private final Optional<Identifier> targetAlias;
    private final Relation relation;
    private final Expression expression;
    private final List<MergeCase> mergeCases;

    public Merge(Table table, Optional<Identifier> targetAlias, Relation relation, Expression expression, List<MergeCase> mergeCases) {
        this(Optional.empty(), table, targetAlias, relation, expression, mergeCases);
    }

    public Merge(NodeLocation location, Table table, Optional<Identifier> targetAlias, Relation relation, Expression expression, List<MergeCase> mergeCases) {
        this(Optional.of(location), table, targetAlias, relation, expression, mergeCases);
    }

    public Merge(Optional<NodeLocation> location, Table table, Optional<Identifier> targetAlias, Relation relation, Expression expression, List<MergeCase> mergeCases) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.targetAlias = Objects.requireNonNull(targetAlias, "targetAlias is null");
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.mergeCases = ImmutableList.copyOf((Collection)Objects.requireNonNull(mergeCases, "mergeCases is null"));
    }

    public Table getTable() {
        return this.table;
    }

    public Optional<Identifier> getTargetAlias() {
        return this.targetAlias;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<MergeCase> getMergeCases() {
        return this.mergeCases;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMerge(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.table);
        builder.add((Object)this.relation);
        builder.add((Object)this.expression);
        builder.addAll(this.mergeCases);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merge merge = (Merge)o;
        return Objects.equals(this.table, merge.table) && Objects.equals(this.targetAlias, merge.targetAlias) && Objects.equals(this.relation, merge.relation) && Objects.equals(this.expression, merge.expression) && Objects.equals(this.mergeCases, merge.mergeCases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.targetAlias, this.relation, this.expression, this.mergeCases);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("targetAlias", this.targetAlias.orElse(null)).add("relation", (Object)this.relation).add("expression", (Object)this.expression).add("mergeCases", this.mergeCases).omitNullValues().toString();
    }
}

