/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableExecute
extends Statement {
    private final Table table;
    private final Identifier procedureName;
    private final List<CallArgument> arguments;
    private final Optional<Expression> where;

    public TableExecute(Table table, Identifier procedureName, List<CallArgument> properties, Optional<Expression> where) {
        this(Optional.empty(), table, procedureName, properties, where);
    }

    public TableExecute(NodeLocation location, Table table, Identifier procedureName, List<CallArgument> arguments, Optional<Expression> where) {
        this(Optional.of(location), table, procedureName, arguments, where);
    }

    private TableExecute(Optional<NodeLocation> location, Table table, Identifier procedureName, List<CallArgument> arguments, Optional<Expression> where) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.procedureName = Objects.requireNonNull(procedureName, "procedureName is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public Identifier getProcedureName() {
        return this.procedureName;
    }

    public List<CallArgument> getArguments() {
        return this.arguments;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableExecute(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.arguments);
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.procedureName, this.arguments, this.where);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableExecute that = (TableExecute)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.procedureName, that.procedureName) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.where, that.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("procedureNaem", (Object)this.procedureName).add("arguments", this.arguments).add("where", this.where).toString();
    }
}

