/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.FieldValueProvider;

public final class FieldValueProviders {
    private static final FieldValueProvider NULL_VALUE_PROVIDER = new FieldValueProvider(){

        @Override
        public boolean isNull() {
            return true;
        }
    };

    private FieldValueProviders() {
    }

    public static FieldValueProvider booleanValueProvider(final boolean value) {
        return new FieldValueProvider(){

            @Override
            public boolean getBoolean() {
                return value;
            }

            @Override
            public boolean isNull() {
                return false;
            }
        };
    }

    public static FieldValueProvider longValueProvider(final long value) {
        return new FieldValueProvider(){

            @Override
            public long getLong() {
                return value;
            }

            @Override
            public boolean isNull() {
                return false;
            }
        };
    }

    public static FieldValueProvider bytesValueProvider(final byte[] value) {
        return new FieldValueProvider(){

            @Override
            public Slice getSlice() {
                return Slices.wrappedBuffer((byte[])value);
            }

            @Override
            public boolean isNull() {
                return value == null || value.length == 0;
            }
        };
    }

    public static FieldValueProvider nullValueProvider() {
        return NULL_VALUE_PROVIDER;
    }
}

