/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.pulsar.client.admin.Clusters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget adminClusters;

    public ClustersImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminClusters = web.path("/admin/v2/clusters");
    }

    public List<String> getClusters() throws PulsarAdminException {
        return (List)this.sync(this::getClustersAsync);
    }

    public CompletableFuture<List<String>> getClustersAsync() {
        WebTarget path = this.adminClusters;
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        return (ClusterData)this.sync(() -> this.getClusterAsync(cluster));
    }

    public CompletableFuture<ClusterData> getClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<ClusterDataImpl>(){}).thenApply(clusterData -> clusterData);
    }

    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.createClusterAsync(cluster, clusterData));
    }

    public CompletableFuture<Void> createClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPutRequest(path, Entity.entity((Object)((ClusterDataImpl)clusterData), (String)"application/json"));
    }

    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        this.sync(() -> this.updateClusterAsync(cluster, clusterData));
    }

    public CompletableFuture<Void> updateClusterAsync(String cluster, ClusterData clusterData) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncPostRequest(path, Entity.entity((Object)((ClusterDataImpl)clusterData), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updatePeerClusterNames(String cluster, LinkedHashSet<String> peerClusterNames) throws PulsarAdminException {
        this.sync(() -> this.updatePeerClusterNamesAsync(cluster, peerClusterNames));
    }

    public CompletableFuture<Void> updatePeerClusterNamesAsync(String cluster, LinkedHashSet<String> peerClusterNames) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncPostRequest(path, Entity.entity(peerClusterNames, (String)"application/json"));
    }

    public void updateClusterMigration(String cluster, boolean isMigrated, ClusterData.ClusterUrl clusterUrl) throws PulsarAdminException {
        this.sync(() -> this.updateClusterMigrationAsync(cluster, isMigrated, clusterUrl));
    }

    public CompletableFuture<Void> updateClusterMigrationAsync(String cluster, boolean isMigrated, ClusterData.ClusterUrl clusterUrl) {
        WebTarget path = this.adminClusters.path(cluster).path("migrate").queryParam("migrated", new Object[]{isMigrated});
        return this.asyncPostRequest(path, Entity.entity((Object)clusterUrl, (String)"application/json"));
    }

    public Set<String> getPeerClusterNames(String cluster) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getPeerClusterNamesAsync(cluster));
    }

    public CompletableFuture<Set<String>> getPeerClusterNamesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("peers");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Set<String>>(){});
    }

    public void deleteCluster(String cluster) throws PulsarAdminException {
        this.sync(() -> this.deleteClusterAsync(cluster));
    }

    public CompletableFuture<Void> deleteClusterAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getNamespaceIsolationPoliciesAsync(cluster));
    }

    public CompletableFuture<Map<String, NamespaceIsolationData>> getNamespaceIsolationPoliciesAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, NamespaceIsolationDataImpl>>(){}).thenApply(HashMap::new);
    }

    public List<BrokerNamespaceIsolationData> getBrokersWithNamespaceIsolationPolicy(String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getBrokersWithNamespaceIsolationPolicyAsync(cluster));
    }

    public CompletableFuture<List<BrokerNamespaceIsolationData>> getBrokersWithNamespaceIsolationPolicyAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<BrokerNamespaceIsolationDataImpl>>(){}).thenApply(ArrayList::new);
    }

    public BrokerNamespaceIsolationData getBrokerWithNamespaceIsolationPolicy(String cluster, String broker) throws PulsarAdminException {
        return (BrokerNamespaceIsolationData)this.sync(() -> this.getBrokerWithNamespaceIsolationPolicyAsync(cluster, broker));
    }

    public CompletableFuture<BrokerNamespaceIsolationData> getBrokerWithNamespaceIsolationPolicyAsync(String cluster, String broker) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path("brokers").path(broker);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BrokerNamespaceIsolationDataImpl>(){}).thenApply(brokerNamespaceIsolationData -> brokerNamespaceIsolationData);
    }

    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    public CompletableFuture<Void> createNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    public CompletableFuture<Void> updateNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        return this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData);
    }

    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    public CompletableFuture<Void> deleteNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncDeleteRequest(path);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceIsolationPolicyAsync(cluster, policyName, namespaceIsolationData));
    }

    private CompletableFuture<Void> setNamespaceIsolationPolicyAsync(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncPostRequest(path, Entity.entity((Object)namespaceIsolationData, (String)"application/json"));
    }

    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        return (NamespaceIsolationData)this.sync(() -> this.getNamespaceIsolationPolicyAsync(cluster, policyName));
    }

    public CompletableFuture<NamespaceIsolationData> getNamespaceIsolationPolicyAsync(String cluster, String policyName) {
        WebTarget path = this.adminClusters.path(cluster).path("namespaceIsolationPolicies").path(policyName);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<NamespaceIsolationDataImpl>(){}).thenApply(namespaceIsolationData -> namespaceIsolationData);
    }

    public void createFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    public CompletableFuture<Void> createFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    public void updateFailureDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.setDomain(cluster, domainName, domain);
    }

    public CompletableFuture<Void> updateFailureDomainAsync(String cluster, String domainName, FailureDomain domain) {
        return this.setDomainAsync(cluster, domainName, domain);
    }

    public void deleteFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        this.sync(() -> this.deleteFailureDomainAsync(cluster, domainName));
    }

    public CompletableFuture<Void> deleteFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, FailureDomain> getFailureDomains(String cluster) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getFailureDomainsAsync(cluster));
    }

    public CompletableFuture<Map<String, FailureDomain>> getFailureDomainsAsync(String cluster) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, FailureDomainImpl>>(){}).thenApply(HashMap::new);
    }

    public FailureDomain getFailureDomain(String cluster, String domainName) throws PulsarAdminException {
        return (FailureDomain)this.sync(() -> this.getFailureDomainAsync(cluster, domainName));
    }

    public CompletableFuture<FailureDomain> getFailureDomainAsync(String cluster, String domainName) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<FailureDomainImpl>(){}).thenApply(failureDomain -> failureDomain);
    }

    private void setDomain(String cluster, String domainName, FailureDomain domain) throws PulsarAdminException {
        this.sync(() -> this.setDomainAsync(cluster, domainName, domain));
    }

    private CompletableFuture<Void> setDomainAsync(String cluster, String domainName, FailureDomain domain) {
        WebTarget path = this.adminClusters.path(cluster).path("failureDomains").path(domainName);
        return this.asyncPostRequest(path, Entity.entity((Object)((FailureDomainImpl)domain), (String)"application/json"));
    }
}

