/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.store;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.discovery.store.Entry;
import io.airlift.discovery.store.LocalStore;
import io.airlift.discovery.store.StoreConfig;
import io.airlift.discovery.store.Version;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/store/{store}")
public class StoreResource {
    private final Map<String, LocalStore> localStores;
    private final Map<String, Duration> tombstoneMaxAges;

    @Inject
    public StoreResource(Map<String, LocalStore> localStores, Map<String, StoreConfig> configs) {
        this.localStores = ImmutableMap.copyOf(localStores);
        this.tombstoneMaxAges = ImmutableMap.copyOf((Map)Maps.transformValues(configs, (Function)new Function<StoreConfig, Duration>(){

            public Duration apply(@Nullable StoreConfig config) {
                return config.getTombstoneMaxAge();
            }
        }));
    }

    @PUT
    @Path(value="{key}")
    public void put(@PathParam(value="store") String storeName, @PathParam(value="key") String key, byte[] value) {
        LocalStore store = this.localStores.get(storeName);
        Entry entry = new Entry(key.getBytes(Charsets.UTF_8), value, new Version(System.currentTimeMillis()), System.currentTimeMillis(), null);
        store.put(entry);
    }

    @POST
    @Consumes(value={"application/x-jackson-smile", "application/json"})
    public Response setMultipleEntries(@PathParam(value="store") String storeName, List<Entry> entries) {
        LocalStore store = this.localStores.get(storeName);
        Duration tombstoneMaxAge = this.tombstoneMaxAges.get(storeName);
        if (store == null || tombstoneMaxAge == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (Entry entry : entries) {
            if (this.isExpired(tombstoneMaxAge, entry)) continue;
            store.put(entry);
        }
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/x-jackson-smile", "application/json"})
    public Response getAll(@PathParam(value="store") String storeName) {
        LocalStore store = this.localStores.get(storeName);
        if (store == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(store.getAll()).build();
    }

    private boolean isExpired(Duration tombstoneMaxAge, Entry entry) {
        long ageInMs = System.currentTimeMillis() - entry.getTimestamp();
        return entry.getValue() == null && ageInMs > tombstoneMaxAge.toMillis() || entry.getMaxAgeInMs() != null && ageInMs > entry.getMaxAgeInMs();
    }
}

