/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;

public final class BlockSerdeUtil {
    public static final MethodHandle READ_BLOCK = Reflection.methodHandle(BlockSerdeUtil.class, "readBlock", BlockEncodingSerde.class, Slice.class);
    public static final MethodHandle READ_BLOCK_VALUE = Reflection.methodHandle(BlockSerdeUtil.class, "readBlockValue", BlockEncodingSerde.class, Type.class, Slice.class);

    private BlockSerdeUtil() {
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, Slice slice) {
        return BlockSerdeUtil.readBlock(blockEncodingSerde, (SliceInput)slice.getInput());
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput input) {
        return blockEncodingSerde.readBlock(input);
    }

    public static Object readBlockValue(BlockEncodingSerde blockEncodingSerde, Type type, Slice slice) {
        Block block = BlockSerdeUtil.readBlock(blockEncodingSerde, (SliceInput)slice.getInput());
        return type.getObject(block, 0);
    }

    public static void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput output, Block block) {
        blockEncodingSerde.writeBlock(output, block);
    }
}

