/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BufferResult {
    private final String taskInstanceId;
    private final long token;
    private final long nextToken;
    private final boolean bufferComplete;
    private final List<Slice> serializedPages;

    public static BufferResult emptyResults(String taskInstanceId, long token, boolean bufferComplete) {
        return new BufferResult(taskInstanceId, token, token, bufferComplete, (List<Slice>)ImmutableList.of());
    }

    public BufferResult(String taskInstanceId, long token, long nextToken, boolean bufferComplete, List<Slice> serializedPages) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskInstanceId) ? 1 : 0) != 0, (Object)"taskInstanceId is null");
        this.taskInstanceId = taskInstanceId;
        this.token = token;
        this.nextToken = nextToken;
        this.bufferComplete = bufferComplete;
        this.serializedPages = ImmutableList.copyOf((Collection)Objects.requireNonNull(serializedPages, "serializedPages is null"));
    }

    public long getToken() {
        return this.token;
    }

    public long getNextToken() {
        return this.nextToken;
    }

    public boolean isBufferComplete() {
        return this.bufferComplete;
    }

    public List<Slice> getSerializedPages() {
        return this.serializedPages;
    }

    public int size() {
        return this.serializedPages.size();
    }

    public boolean isEmpty() {
        return this.serializedPages.isEmpty();
    }

    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferResult that = (BufferResult)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.nextToken, that.nextToken) && Objects.equals(this.taskInstanceId, that.taskInstanceId) && Objects.equals(this.bufferComplete, that.bufferComplete) && Objects.equals(this.serializedPages, that.serializedPages);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.nextToken, this.taskInstanceId, this.bufferComplete, this.serializedPages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("taskInstanceId", (Object)this.taskInstanceId).add("bufferComplete", this.bufferComplete).add("serializedPages", this.serializedPages).toString();
    }
}

