/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.metadata.AllNodes;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class InMemoryNodeManager
implements InternalNodeManager {
    private final InternalNode localNode;
    private final SetMultimap<CatalogName, InternalNode> remoteNodes = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @GuardedBy(value="this")
    private final List<Consumer<AllNodes>> listeners = new ArrayList<Consumer<AllNodes>>();

    @Inject
    public InMemoryNodeManager() {
        this(URI.create("local://127.0.0.1:8080"));
    }

    public InMemoryNodeManager(URI localUri) {
        this.localNode = new InternalNode("local", localUri, NodeVersion.UNKNOWN, true);
    }

    public void addCurrentNodeConnector(CatalogName catalogName) {
        this.addNode(catalogName, this.localNode);
    }

    public void addNode(CatalogName catalogName, InternalNode ... nodes) {
        this.addNode(catalogName, (Iterable<InternalNode>)ImmutableList.copyOf((Object[])nodes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(CatalogName catalogName, Iterable<InternalNode> nodes) {
        ImmutableList listeners;
        this.remoteNodes.putAll((Object)catalogName, nodes);
        InMemoryNodeManager inMemoryNodeManager = this;
        synchronized (inMemoryNodeManager) {
            listeners = ImmutableList.copyOf(this.listeners);
        }
        AllNodes allNodes = this.getAllNodes();
        listeners.forEach(listener -> listener.accept(allNodes));
    }

    @Override
    public Set<InternalNode> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return this.getAllNodes().getActiveNodes();
            }
            case INACTIVE: {
                return this.getAllNodes().getInactiveNodes();
            }
            case SHUTTING_DOWN: {
                return this.getAllNodes().getShuttingDownNodes();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + state);
    }

    @Override
    public Set<InternalNode> getActiveConnectorNodes(CatalogName catalogName) {
        return ImmutableSet.copyOf((Collection)this.remoteNodes.get((Object)catalogName));
    }

    @Override
    public AllNodes getAllNodes() {
        return new AllNodes((Set<InternalNode>)ImmutableSet.builder().add((Object)this.localNode).addAll((Iterable)this.remoteNodes.values()).build(), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of((Object)this.localNode));
    }

    @Override
    public InternalNode getCurrentNode() {
        return this.localNode;
    }

    @Override
    public Set<InternalNode> getCoordinators() {
        return ImmutableSet.of((Object)this.localNode);
    }

    @Override
    public void refreshNodes() {
    }

    @Override
    public synchronized void addNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener is null"));
    }

    @Override
    public synchronized void removeNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.remove(Objects.requireNonNull(listener, "listener is null"));
    }
}

