/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.MultiChannelGroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;

public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        return GroupByHash.createGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, blockTypeOperators, updateMemory);
    }

    public static GroupByHash createGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        if (hashTypes.size() == 1 && hashTypes.get(0).equals(BigintType.BIGINT) && hashChannels.length == 1) {
            return new BigintGroupByHash(hashChannels[0], inputHashChannel.isPresent(), expectedSize, updateMemory);
        }
        return new MultiChannelGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, processDictionary, joinCompiler, blockTypeOperators, updateMemory);
    }

    public long getEstimatedSize();

    public long getHashCollisions();

    public double getExpectedHashCollisions();

    public List<Type> getTypes();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2, int var3);

    public Work<?> addPage(Page var1);

    public Work<GroupByIdBlock> getGroupIds(Page var1);

    public boolean contains(int var1, Page var2, int[] var3);

    default public boolean contains(int position, Page page, int[] hashChannels, long rawHash) {
        return this.contains(position, page, hashChannels);
    }

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();
}

