/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.DoubleState;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TypeSignature;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RealAverageAggregation
extends SqlAggregationFunction {
    public static final RealAverageAggregation REAL_AVERAGE_AGGREGATION = new RealAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "input", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle REMOVE_INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "removeInput", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "combine", LongState.class, DoubleState.class, LongState.class, DoubleState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "output", LongState.class, DoubleState.class, BlockBuilder.class);

    protected RealAverageAggregation() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), RealType.REAL.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)RealType.REAL.getTypeSignature()), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Returns the average value of the argument", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Class<LongState> longStateInterface = LongState.class;
        Class<DoubleState> doubleStateInterface = DoubleState.class;
        AccumulatorStateSerializer<LongState> longStateSerializer = StateCompiler.generateStateSerializer(longStateInterface);
        AccumulatorStateSerializer<DoubleState> doubleStateSerializer = StateCompiler.generateStateSerializer(doubleStateInterface);
        MethodHandle inputFunction = AggregationFunctionAdapter.normalizeInputMethod(INPUT_FUNCTION, boundSignature, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL);
        MethodHandle removeFunction = AggregationFunctionAdapter.normalizeInputMethod(REMOVE_INPUT_FUNCTION, boundSignature, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL);
        return new AggregationMetadata(inputFunction, Optional.of(removeFunction), Optional.of(COMBINE_FUNCTION), OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<LongState>(longStateInterface, longStateSerializer, StateCompiler.generateStateFactory(longStateInterface)), new AggregationMetadata.AccumulatorStateDescriptor<DoubleState>(doubleStateInterface, doubleStateSerializer, StateCompiler.generateStateFactory(doubleStateInterface))));
    }

    public static void input(LongState count, DoubleState sum, long value) {
        count.setValue(count.getValue() + 1L);
        sum.setValue(sum.getValue() + (double)Float.intBitsToFloat((int)value));
    }

    public static void removeInput(LongState count, DoubleState sum, long value) {
        count.setValue(count.getValue() - 1L);
        sum.setValue(sum.getValue() - (double)Float.intBitsToFloat((int)value));
    }

    public static void combine(LongState count, DoubleState sum, LongState otherCount, DoubleState otherSum) {
        count.setValue(count.getValue() + otherCount.getValue());
        sum.setValue(sum.getValue() + otherSum.getValue());
    }

    public static void output(LongState count, DoubleState sum, BlockBuilder out) {
        if (count.getValue() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToIntBits((float)(sum.getValue() / (double)count.getValue())));
        }
    }
}

