/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.base.Preconditions;
import io.trino.spi.function.AccumulatorState;

public interface CentralMomentsState
extends AccumulatorState {
    public long getCount();

    public void setCount(long var1);

    public double getM1();

    public void setM1(double var1);

    public double getM2();

    public void setM2(double var1);

    public double getM3();

    public void setM3(double var1);

    public double getM4();

    public void setM4(double var1);

    default public void update(double value) {
        long n1 = this.getCount();
        long n = n1 + 1L;
        double m1 = this.getM1();
        double m2 = this.getM2();
        double m3 = this.getM3();
        double delta = value - m1;
        double deltaN = delta / (double)n;
        double deltaN2 = deltaN * deltaN;
        double dm2 = delta * deltaN * (double)n1;
        this.setCount(n);
        this.setM1(m1 + deltaN);
        this.setM2(m2 + dm2);
        this.setM3(m3 + dm2 * deltaN * (double)(n - 2L) - 3.0 * deltaN * m2);
        this.setM4(this.getM4() + dm2 * deltaN2 * ((double)n * (double)n - (double)(3L * n) + 3.0) + 6.0 * deltaN2 * m2 - 4.0 * deltaN * m3);
    }

    default public void merge(CentralMomentsState otherState) {
        long na = this.getCount();
        long nb = otherState.getCount();
        Preconditions.checkArgument((nb >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (nb == 0L) {
            return;
        }
        double m1a = this.getM1();
        double m2a = this.getM2();
        double m3a = this.getM3();
        double m1b = otherState.getM1();
        double m2b = otherState.getM2();
        double m3b = otherState.getM3();
        double n = na + nb;
        double delta = m1b - m1a;
        double delta2 = delta * delta;
        double delta3 = delta * delta2;
        double delta4 = delta2 * delta2;
        this.setCount((long)n);
        this.setM1(((double)na * m1a + (double)nb * m1b) / n);
        this.setM2(m2a + m2b + delta2 * (double)na * (double)nb / n);
        this.setM3(m3a + m3b + delta3 * (double)na * (double)nb * (double)(na - nb) / (n * n) + 3.0 * delta * ((double)na * m2b - (double)nb * m2a) / n);
        this.setM4(this.getM4() + otherState.getM4() + delta4 * (double)na * (double)nb * (double)(na * na - na * nb + nb * nb) / (n * n * n) + 6.0 * delta2 * ((double)(na * na) * m2b + (double)(nb * nb) * m2a) / (n * n) + 4.0 * delta * ((double)na * m3b - (double)nb * m3a) / n);
    }
}

