/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.array.LongBigArray;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import org.openjdk.jol.info.ClassLayout;

public class LongDecimalWithOverflowAndLongStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowAndLongState> {
    public LongDecimalWithOverflowAndLongState createSingleState() {
        return new SingleLongDecimalWithOverflowAndLongState();
    }

    public LongDecimalWithOverflowAndLongState createGroupedState() {
        return new GroupedLongDecimalWithOverflowAndLongState();
    }

    public static class SingleLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleLongDecimalWithOverflowAndLongState.class).instanceSize();
        protected long longValue;

        public SingleLongDecimalWithOverflowAndLongState() {
        }

        private SingleLongDecimalWithOverflowAndLongState(long longValue) {
            this.longValue = longValue;
        }

        @Override
        public long getLong() {
            return this.longValue;
        }

        @Override
        public void setLong(long longValue) {
            this.longValue = longValue;
        }

        @Override
        public void addLong(long value) {
            this.longValue += value;
        }

        @Override
        public long getEstimatedSize() {
            return INSTANCE_SIZE + SIZE;
        }

        @Override
        public AccumulatorState copy() {
            return new SingleLongDecimalWithOverflowAndLongState(this.longValue);
        }
    }

    public static class GroupedLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.GroupedLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedLongDecimalWithOverflowAndLongState.class).instanceSize();
        private final LongBigArray longs = new LongBigArray();

        @Override
        public void ensureCapacity(long size) {
            this.longs.ensureCapacity(size);
            super.ensureCapacity(size);
        }

        @Override
        public long getLong() {
            return this.longs.get(this.getGroupId());
        }

        @Override
        public void setLong(long value) {
            this.longs.set(this.getGroupId(), value);
        }

        @Override
        public void addLong(long value) {
            this.longs.add(this.getGroupId(), value);
        }

        @Override
        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.isNotNull.sizeOf() + this.unscaledDecimals.sizeOf() + (this.overflows == null ? 0L : this.overflows.sizeOf());
        }
    }
}

