/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.operator.join.NestedLoopJoinBridge;
import io.trino.operator.join.NestedLoopJoinPages;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class NestedLoopJoinPagesSupplier
implements NestedLoopJoinBridge {
    private final SettableFuture<NestedLoopJoinPages> pagesFuture = SettableFuture.create();
    private final SettableFuture<Void> pagesNoLongerNeeded = SettableFuture.create();

    @Override
    public ListenableFuture<NestedLoopJoinPages> getPagesFuture() {
        return Futures.transformAsync(this.pagesFuture, Futures::immediateFuture, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<Void> setPages(NestedLoopJoinPages nestedLoopJoinPages) {
        Objects.requireNonNull(nestedLoopJoinPages, "nestedLoopJoinPages is null");
        boolean wasSet = this.pagesFuture.set((Object)nestedLoopJoinPages);
        Preconditions.checkState((boolean)wasSet, (Object)"pagesFuture already set");
        return this.pagesNoLongerNeeded;
    }

    @Override
    public void destroy() {
        this.pagesNoLongerNeeded.set(null);
    }
}

