/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public final class ArrayConcatUtils {
    private ArrayConcatUtils() {
    }

    @UsedByGeneratedCode
    public static Block appendElement(Type elementType, Block block, long value) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        elementType.writeLong(blockBuilder, value);
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block appendElement(Type elementType, Block block, boolean value) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        elementType.writeBoolean(blockBuilder, value);
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block appendElement(Type elementType, Block block, double value) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        elementType.writeDouble(blockBuilder, value);
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block appendElement(Type elementType, Block block, Slice value) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        elementType.writeSlice(blockBuilder, value);
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block appendElement(Type elementType, Block block, Object value) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        elementType.writeObject(blockBuilder, value);
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block prependElement(Type elementType, Slice value, Block block) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        elementType.writeSlice(blockBuilder, value);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block prependElement(Type elementType, Object value, Block block) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        elementType.writeObject(blockBuilder, value);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block prependElement(Type elementType, long value, Block block) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        elementType.writeLong(blockBuilder, value);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block prependElement(Type elementType, boolean value, Block block) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        elementType.writeBoolean(blockBuilder, value);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }

    @UsedByGeneratedCode
    public static Block prependElement(Type elementType, double value, Block block) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, block.getPositionCount() + 1);
        elementType.writeDouble(blockBuilder, value);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            elementType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

