/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.Varchars;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public final class CharacterStringCasts {
    private CharacterStringCasts() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToCharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharCast(@LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        return Chars.truncateToLengthAndTrimSpaces((Slice)slice, (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x.intValue() <= y.intValue()) {
            return Chars.padSpaces((Slice)slice, (int)x.intValue());
        }
        return Chars.padSpaces((Slice)Varchars.truncateToLength((Slice)slice, (int)y.intValue()), (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharSaturatedFloorCast(@LiteralParameter(value="y") long y, @SqlType(value="varchar(x)") Slice slice) {
        IntList codePoints = CharacterStringCasts.toCodePoints(slice);
        if ((long)codePoints.size() >= y) {
            codePoints.size(Math.min(Math.toIntExact(y), codePoints.size()));
            CharacterStringCasts.trimTrailing(codePoints, 32);
            return CharacterStringCasts.codePointsToSliceUtf8(codePoints);
        }
        CharacterStringCasts.trimTrailing(codePoints, 0);
        if (codePoints.isEmpty()) {
            return Slices.allocate((int)Math.toIntExact(y));
        }
        codePoints.set(codePoints.size() - 1, codePoints.get(codePoints.size() - 1) - 1);
        int toAdd = Math.toIntExact(y) - codePoints.size();
        for (int i = 0; i < toAdd; ++i) {
            codePoints.add(0x10FFFF);
        }
        Verify.verify((codePoints.getInt(codePoints.size() - 1) != 32 ? 1 : 0) != 0);
        return CharacterStringCasts.codePointsToSliceUtf8(codePoints);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToVarcharSaturatedFloorCast(@LiteralParameter(value="y") long y, @SqlType(value="varchar(x)") Slice slice) {
        if ((long)SliceUtf8.countCodePoints((Slice)slice) <= y) {
            return slice;
        }
        IntList codePoints = CharacterStringCasts.toCodePoints(slice);
        codePoints.size(Math.toIntExact(y));
        return CharacterStringCasts.codePointsToSliceUtf8(codePoints);
    }

    private static void trimTrailing(IntList codePoints, int codePointToTrim) {
        int endIndex;
        for (endIndex = codePoints.size(); endIndex > 0 && codePoints.get(endIndex - 1) == codePointToTrim; --endIndex) {
        }
        codePoints.size(endIndex);
    }

    private static IntList toCodePoints(Slice slice) {
        IntArrayList codePoints = new IntArrayList(slice.length());
        for (int offset = 0; offset < slice.length(); offset += SliceUtf8.lengthOfCodePoint((Slice)slice, (int)offset)) {
            int codePoint = SliceUtf8.getCodePointAt((Slice)slice, (int)offset);
            codePoints.add(codePoint);
        }
        return codePoints;
    }

    public static Slice codePointsToSliceUtf8(IntList codePoints) {
        int bufferLength = 0;
        IntListIterator intListIterator = codePoints.iterator();
        while (intListIterator.hasNext()) {
            int codePoint = (Integer)intListIterator.next();
            bufferLength += SliceUtf8.lengthOfCodePoint((int)codePoint);
        }
        Slice result = Slices.wrappedBuffer((byte[])new byte[bufferLength]);
        int offset = 0;
        IntListIterator intListIterator2 = codePoints.iterator();
        while (intListIterator2.hasNext()) {
            int codePoint = (Integer)intListIterator2.next();
            SliceUtf8.setCodePointAt((int)codePoint, (Slice)result, (int)offset);
            offset += SliceUtf8.lengthOfCodePoint((int)codePoint);
        }
        return result;
    }
}

