/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Chars;
import io.trino.type.JoniRegexp;

public final class JoniRegexpCasts {
    private JoniRegexpCasts() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="JoniRegExp")
    public static JoniRegexp castVarcharToJoniRegexp(@SqlType(value="varchar(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(pattern);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="JoniRegExp")
    public static JoniRegexp castCharToJoniRegexp(@LiteralParameter(value="x") Long charLength, @SqlType(value="char(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(Chars.padSpaces((Slice)pattern, (int)charLength.intValue()));
    }

    public static JoniRegexp joniRegexp(Slice pattern) {
        Regex regex;
        try {
            regex = new Regex(pattern.getBytes(), 0, pattern.length(), 0, (Encoding)NonStrictUTF8Encoding.INSTANCE, Syntax.Java);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        return new JoniRegexp(pattern, regex);
    }
}

