/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.time;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.type.Constraint;
import io.trino.type.DateTimes;
import java.nio.charset.StandardCharsets;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p"})
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        long interval = left - right;
        interval = DateTimes.rescaleWithRounding(interval, 12, 3);
        return interval;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p)")
    public static long castFromVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice value) {
        try {
            long picos = DateTimes.parseTime(value.toStringUtf8());
            return DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long castToTime(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision)") long time) {
        if (sourcePrecision <= targetPrecision) {
            return time;
        }
        return DateTimes.round(time, (int)(12L - targetPrecision)) % 86400000000000000L;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timePlusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long intervalDayToSecondPlusTime(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p)") long time) {
        return TimeOperators.timePlusIntervalDayToSecond(time, interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timeMinusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, -interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="time(p)") long value) {
        int size = (int)((long)(8 + (precision > 0L ? 1 : 0)) + precision);
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        String formatted = String.format("%02d:%02d:%02d", value / 3600000000000000L, value / 60000000000000L % 60L, value / 1000000000000L % 60L);
        output.appendBytes(formatted.getBytes(StandardCharsets.UTF_8));
        if (precision > 0L) {
            long scaledFraction = value % 1000000000000L / DateTimes.scaleFactor((int)precision, 12);
            output.appendByte(46);
            output.appendBytes(String.format("%0" + precision + "d", scaledFraction).getBytes(StandardCharsets.UTF_8));
        }
        return output.slice();
    }

    public static long add(long picos, long delta) {
        long result = (picos + delta) % 86400000000000000L;
        if (result < 0L) {
            result += 86400000000000000L;
        }
        return result;
    }
}

