/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.type.Type;

class ArrayUnnester
extends Unnester {
    private ColumnarArray columnarArray;

    public ArrayUnnester(Type elementType) {
        super(elementType);
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    protected int getInputEntryCount() {
        if (this.columnarArray == null) {
            return 0;
        }
        return this.columnarArray.getPositionCount();
    }

    @Override
    protected void resetColumnarStructure(Block block) {
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
    }

    @Override
    protected Block getElementsBlock(int channel) {
        Preconditions.checkState((channel == 0 ? 1 : 0) != 0, (Object)"index is not 0");
        return this.columnarArray.getElementsBlock();
    }

    @Override
    protected void processCurrentPosition(int requiredOutputCount) {
        int startElementIndex = this.columnarArray.getOffset(this.getCurrentPosition());
        int length = this.columnarArray.getLength(this.getCurrentPosition());
        this.getBlockBuilder(0).appendRange(startElementIndex, length);
        this.appendNulls(requiredOutputCount - length);
    }

    @Override
    protected void appendNulls(int count) {
        for (int i = 0; i < count; ++i) {
            this.getBlockBuilder(0).appendNull();
        }
    }

    @Override
    protected int getElementsLength(int index) {
        return this.columnarArray.getLength(index);
    }
}

