/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.IntList;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SetEvaluator {
    private static final int DEFAULT_CAPACITY = 10;
    private final Set<Integer> labels;
    private final boolean running;
    private int aggregated;
    private int evaluated;
    private final IntList allPositions;

    public SetEvaluator(Set<Integer> labels, boolean running) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.running = running;
        this.allPositions = new IntList(10);
    }

    private SetEvaluator(Set<Integer> labels, boolean running, int aggregated, int evaluated, IntList allPositions) {
        this.labels = labels;
        this.running = running;
        this.aggregated = aggregated;
        this.evaluated = evaluated;
        this.allPositions = allPositions;
    }

    public void reset() {
        this.aggregated = 0;
        this.evaluated = 0;
        this.allPositions.clear();
    }

    public ArrayView resolveNewPositions(int currentRow, ArrayView matchedLabels, int partitionStart, int patternStart) {
        Preconditions.checkArgument((currentRow >= patternStart && currentRow < patternStart + matchedLabels.length() ? 1 : 0) != 0, (Object)"current row is out of bounds of the match");
        Preconditions.checkState((this.aggregated <= this.evaluated && this.evaluated <= matchedLabels.length() ? 1 : 0) != 0, (Object)"SetEvaluator in inconsistent state");
        IntList positions = new IntList(10);
        int last = this.running ? currentRow - patternStart : matchedLabels.length() - 1;
        for (int position = this.aggregated; position <= last; ++position) {
            if (this.appliesToLabel(matchedLabels.get(position))) {
                positions.add(position + patternStart - partitionStart);
                if (this.aggregated >= this.evaluated) {
                    this.allPositions.add(position);
                }
            }
            ++this.aggregated;
        }
        this.evaluated = this.aggregated;
        return positions.toArrayView();
    }

    public ArrayView getAllPositions(ArrayView labels) {
        Preconditions.checkState((this.evaluated <= labels.length() ? 1 : 0) != 0, (Object)"SetEvaluator in inconsistent state");
        for (int position = this.evaluated; position < labels.length(); ++position) {
            if (!this.appliesToLabel(labels.get(position))) continue;
            this.allPositions.add(position);
        }
        this.evaluated = labels.length();
        return this.allPositions.toArrayView();
    }

    private boolean appliesToLabel(int label) {
        return this.labels.isEmpty() || this.labels.contains(label);
    }

    public SetEvaluator copy() {
        return new SetEvaluator(this.labels, this.running, this.aggregated, this.evaluated, this.allPositions.copy());
    }

    public long getAllPositionsSizeInBytes() {
        return this.allPositions.getSizeInBytes();
    }

    public static class SetEvaluatorSupplier {
        private final AggregatedSetDescriptor setDescriptor;
        private final Map<IrLabel, Integer> mapping;

        public SetEvaluatorSupplier(AggregatedSetDescriptor setDescriptor, Map<IrLabel, Integer> mapping) {
            this.setDescriptor = Objects.requireNonNull(setDescriptor, "setDescriptor is null");
            this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        }

        public SetEvaluator get() {
            return new SetEvaluator((Set)this.setDescriptor.getLabels().stream().map(this.mapping::get).collect(ImmutableSet.toImmutableSet()), this.setDescriptor.isRunning());
        }
    }
}

