/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.parser.SqlParser;
import java.util.Objects;
import javax.inject.Inject;

public class StatementAnalyzerFactory {
    private final PlannerContext plannerContext;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final GroupProvider groupProvider;
    private final TableProceduresRegistry tableProceduresRegistry;
    private final SessionPropertyManager sessionPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TableProceduresPropertyManager tableProceduresPropertyManager;

    @Inject
    public StatementAnalyzerFactory(PlannerContext plannerContext, SqlParser sqlParser, AccessControl accessControl, GroupProvider groupProvider, TableProceduresRegistry tableProceduresRegistry, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager, AnalyzePropertyManager analyzePropertyManager, TableProceduresPropertyManager tableProceduresPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.tableProceduresRegistry = Objects.requireNonNull(tableProceduresRegistry, "tableProceduresRegistry is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.tableProceduresPropertyManager = Objects.requireNonNull(tableProceduresPropertyManager, "tableProceduresPropertyManager is null");
    }

    public StatementAnalyzerFactory withSpecializedAccessControl(AccessControl accessControl) {
        return new StatementAnalyzerFactory(this.plannerContext, this.sqlParser, accessControl, this.groupProvider, this.tableProceduresRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, this.tableProceduresPropertyManager);
    }

    public StatementAnalyzer createStatementAnalyzer(Analysis analysis, Session session, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        return new StatementAnalyzer(this, analysis, this.plannerContext, this.sqlParser, this.groupProvider, this.accessControl, session, this.tableProceduresRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, this.tableProceduresPropertyManager, warningCollector, correlationSupport);
    }

    public static StatementAnalyzerFactory createTestingStatementAnalyzerFactory(PlannerContext plannerContext, AccessControl accessControl, TablePropertyManager tablePropertyManager, AnalyzePropertyManager analyzePropertyManager) {
        return new StatementAnalyzerFactory(plannerContext, new SqlParser(), accessControl, user -> ImmutableSet.of(), new TableProceduresRegistry(), new SessionPropertyManager(), tablePropertyManager, analyzePropertyManager, new TableProceduresPropertyManager());
    }
}

