/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class TransactionManagerConfig {
    private Duration idleCheckInterval = new Duration(1.0, TimeUnit.MINUTES);
    private Duration idleTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int maxFinishingConcurrency = 1;

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getIdleCheckInterval() {
        return this.idleCheckInterval;
    }

    @Config(value="transaction.idle-check-interval")
    @ConfigDescription(value="Time interval between idle transactions checks")
    public TransactionManagerConfig setIdleCheckInterval(Duration idleCheckInterval) {
        this.idleCheckInterval = idleCheckInterval;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="transaction.idle-timeout")
    @ConfigDescription(value="Amount of time before an inactive transaction is considered expired")
    public TransactionManagerConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxFinishingConcurrency() {
        return this.maxFinishingConcurrency;
    }

    @Config(value="transaction.max-finishing-concurrency")
    @ConfigDescription(value="Maximum parallelism for committing or aborting a transaction")
    public TransactionManagerConfig setMaxFinishingConcurrency(int maxFinishingConcurrency) {
        this.maxFinishingConcurrency = maxFinishingConcurrency;
        return this;
    }
}

