/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Deadline;
import io.grpc.ExperimentalApi;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.WeightedRoundRobinLoadBalancer;
import java.util.Map;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
@Internal
public final class WeightedRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long MIN_WEIGHT_UPDATE_PERIOD_NANOS = 100000000L;
    static final String SCHEME = "weighted_round_robin_experimental";

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WeightedRoundRobinLoadBalancer(helper, Deadline.getSystemTicker());
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return SCHEME;
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        Long blackoutPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"blackoutPeriod");
        Long weightExpirationPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"weightExpirationPeriod");
        Long oobReportingPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"oobReportingPeriod");
        Boolean enableOobLoadReport = JsonUtil.getBoolean(rawConfig, (String)"enableOobLoadReport");
        Long weightUpdatePeriodNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"weightUpdatePeriod");
        WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.Builder configBuilder = WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.newBuilder();
        if (blackoutPeriodNanos != null) {
            configBuilder.setBlackoutPeriodNanos(blackoutPeriodNanos);
        }
        if (weightExpirationPeriodNanos != null) {
            configBuilder.setWeightExpirationPeriodNanos(weightExpirationPeriodNanos);
        }
        if (enableOobLoadReport != null) {
            configBuilder.setEnableOobLoadReport(enableOobLoadReport);
        }
        if (oobReportingPeriodNanos != null) {
            configBuilder.setOobReportingPeriodNanos(oobReportingPeriodNanos);
        }
        if (weightUpdatePeriodNanos != null) {
            configBuilder.setWeightUpdatePeriodNanos(weightUpdatePeriodNanos);
            if (weightUpdatePeriodNanos < 100000000L) {
                configBuilder.setWeightUpdatePeriodNanos(100000000L);
            }
        }
        return NameResolver.ConfigOrError.fromConfig((Object)configBuilder.build());
    }
}

