/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.avro;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.decoder.avro.PulsarAvroColumnDecoder;

public class PulsarAvroRowDecoder
implements PulsarRowDecoder {
    private final GenericAvroSchema genericAvroSchema;
    private final Map<DecoderColumnHandle, PulsarAvroColumnDecoder> columnDecoders;

    public PulsarAvroRowDecoder(GenericAvroSchema genericAvroSchema, Set<DecoderColumnHandle> columns) {
        this.genericAvroSchema = Objects.requireNonNull(genericAvroSchema, "genericAvroSchema is null");
        this.columnDecoders = (Map)columns.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), this::createColumnDecoder));
    }

    private PulsarAvroColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new PulsarAvroColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(ByteBuf byteBuf) {
        GenericRecord avroRecord;
        try {
            GenericAvroRecord record = (GenericAvroRecord)this.genericAvroSchema.decode(byteBuf);
            avroRecord = record.getAvroRecord();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Decoding avro record failed.", (Throwable)e);
        }
        return Optional.of((Map)this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((PulsarAvroColumnDecoder)entry.getValue()).decodeField(avroRecord))));
    }
}

