/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryAllocationValidator;
import io.trino.memory.context.ValidatingLocalMemoryContext;
import java.util.Objects;

public class ValidatingAggregateContext
implements AggregatedMemoryContext {
    private final AggregatedMemoryContext delegate;
    private final MemoryAllocationValidator memoryValidator;

    public ValidatingAggregateContext(AggregatedMemoryContext delegate, MemoryAllocationValidator memoryValidator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.memoryValidator = Objects.requireNonNull(memoryValidator, "memoryValidator is null");
    }

    @Override
    public AggregatedMemoryContext newAggregatedMemoryContext() {
        return new ValidatingAggregateContext(this.delegate.newAggregatedMemoryContext(), this.memoryValidator);
    }

    @Override
    public LocalMemoryContext newLocalMemoryContext(String allocationTag) {
        return new ValidatingLocalMemoryContext(this.delegate.newLocalMemoryContext(allocationTag), allocationTag, this.memoryValidator);
    }

    @Override
    public long getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

