/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.admin.impl.NamespacesBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/namespaces")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/namespaces", description="Namespaces admin apis", tags={"namespaces"}, hidden=true)
public class Namespaces
extends NamespacesBase {
    private static final Logger log = LoggerFactory.getLogger(Namespaces.class);

    @GET
    @Path(value="/{property}")
    @ApiOperation(value="Get the list of all the namespaces for a certain property.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property doesn't exist")})
    public void getTenantNamespaces(@Suspended AsyncResponse response, @PathParam(value="property") String property) {
        ((CompletableFuture)this.internalGetTenantNamespaces(property).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), ex);
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}")
    @ApiOperation(hidden=true, value="Get the list of all the namespaces for a certain property on single cluster.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster doesn't exist")})
    public List<String> getNamespacesForCluster(@PathParam(value="property") String tenant, @PathParam(value="cluster") String cluster) {
        this.validateTenantOperation(tenant, TenantOperation.LIST_NAMESPACES);
        ArrayList<String> namespaces = new ArrayList<String>();
        if (!this.clusters().contains(cluster)) {
            log.warn("[{}] Failed to get namespace list for tenant: {}/{} - Cluster does not exist", new Object[]{this.clientAppId(), tenant, cluster});
            throw new RestException(Response.Status.NOT_FOUND, "Cluster does not exist");
        }
        try {
            for (String namespace : this.clusterResources().getNamespacesForCluster(tenant, cluster)) {
                namespaces.add(NamespaceName.get((String)tenant, (String)cluster, (String)namespace).toString());
            }
        }
        catch (MetadataStoreException.NotFoundException notFoundException) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
        namespaces.sort(null);
        return namespaces;
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/destinations")
    @ApiOperation(hidden=true, value="Get the list of all the topics under a certain namespace.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getTopics(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="mode") @DefaultValue(value="PERSISTENT") CommandGetTopicsOfNamespace.Mode mode, @ApiParam(value="Include system topic") @QueryParam(value="includeSystemTopic") boolean includeSystemTopic) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_TOPICS).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenCompose(policies -> this.internalGetListOfTopics((Policies)policies, mode))).thenApply(topics -> this.filterSystemTopic((List<String>)topics, includeSystemTopic))).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            log.error("Failed to get topics list for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Get the dump all the policies specified for a namespace.", response=Policies.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getPolicies(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(NamespaceName.get((String)property, (String)namespace), PolicyName.ALL, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            log.error("Failed to get policies for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Creates a new empty namespace with no policies attached.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace already exists"), @ApiResponse(code=412, message="Namespace name is not valid")})
    public void createNamespace(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, BundlesData initialBundles) {
        this.validateNamespaceName(property, cluster, namespace);
        CompletableFuture<Object> ret = !this.namespaceName.isGlobal() ? this.validateClusterForTenantAsync(this.namespaceName.getTenant(), this.namespaceName.getCluster()) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)ret.thenApply(__ -> {
            Policies policies = new Policies();
            if (initialBundles != null && initialBundles.getNumBundles() > 0) {
                policies.bundles = initialBundles.getBoundaries() == null || initialBundles.getBoundaries().size() == 0 ? PoliciesUtil.getBundles((int)initialBundles.getNumBundles()) : this.validateBundlesData(initialBundles);
            } else {
                int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
                policies.bundles = PoliciesUtil.getBundles((int)defaultNumberOfBundles);
            }
            return policies;
        })).thenCompose(x$0 -> this.internalCreateNamespace((Policies)x$0))).thenAccept(__ -> response.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            Throwable root = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (root instanceof MetadataStoreException.AlreadyExistsException) {
                response.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Namespace already exists")));
            } else {
                log.error("[{}] Failed to create namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
                Namespaces.resumeAsyncResponseExceptionally(response, ex);
            }
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Delete a namespace and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=405, message="Broker doesn't allow forced deletion of namespaces"), @ApiResponse(code=409, message="Namespace is not empty")})
    public void deleteNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalDeleteNamespaceAsync(force).thenAccept(__ -> {
            log.info("[{}] Successful delete namespace {}", (Object)this.clientAppId(), (Object)namespace);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] Failed to delete namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            }
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Delete a namespace bundle and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace bundle is not empty")})
    public void deleteNamespaceBundle(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalDeleteNamespaceBundleAsync(bundleRange, authoritative, force).thenRun(() -> response.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] Failed to delete namespace bundle {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            }
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/permissions")
    @ApiOperation(hidden=true, value="Retrieve the permissions for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public void getPermissions(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_PERMISSION).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> response.resume((Object)policies.auth_policies.getNamespaceAuthentication()))).exceptionally(ex -> {
            log.error("Failed to get permissions for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/permissions/subscription")
    @ApiOperation(value="Retrieve the permissions for a subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public void getPermissionOnSubscription(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_PERMISSION).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> response.resume((Object)policies.auth_policies.getSubscriptionAuthentication()))).exceptionally(ex -> {
            log.error("[{}] Failed to get permissions on subscription for namespace {}: {} ", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{role}")
    @ApiOperation(hidden=true, value="Grant a new permission to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role, Set<AuthAction> actions) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGrantPermissionOnNamespaceAsync(role, actions).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to grant permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/permissions/subscription/{subscription}")
    @ApiOperation(hidden=true, value="Grant a new permission to roles for a subscription. [Tenant admin is allowed to perform this operation]")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, Set<String> roles) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGrantPermissionOnSubscriptionAsync(subscription, roles).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to grant permission on subscription for role {}:{} - namespaceName {}: {}", new Object[]{this.clientAppId(), roles, subscription, this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{role}")
    @ApiOperation(hidden=true, value="Revoke all permissions to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void revokePermissionsOnNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalRevokePermissionsOnNamespaceAsync(role).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to revoke permission on role {} - namespace {}: {}", new Object[]{this.clientAppId(), role, namespace, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{subscription}/{role}")
    @ApiOperation(hidden=true, value="Revoke subscription admin-api access permission for a role.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void revokePermissionOnSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="role") String role) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalRevokePermissionsOnSubscriptionAsync(subscription, role).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to revoke permission on subscription for role {}:{} - namespace {}: {}", new Object[]{this.clientAppId(), role, subscription, namespace, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/replication")
    @ApiOperation(hidden=true, value="Get the replication clusters for a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not global")})
    public void getNamespaceReplicationClusters(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(NamespaceName.get((String)property, (String)namespace), PolicyName.REPLICATION, PolicyOperation.READ).thenCompose(__ -> this.internalGetNamespaceReplicationClustersAsync())).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> {
            log.error("[{}] Failed to get namespace replication clusters on namespace {}", new Object[]{this.clientAppId(), namespace, e});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, e);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/replication")
    @ApiOperation(hidden=true, value="Set the replication clusters for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Peer-cluster can't be part of replication-cluster"), @ApiResponse(code=412, message="Namespace is not global or invalid cluster ids")})
    public void setNamespaceReplicationClusters(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, List<String> clusterIds) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetNamespaceReplicationClusters(clusterIds).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> {
            log.error("[{}] Failed to set namespace replication clusters on namespace {}", new Object[]{this.clientAppId(), namespace, e});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, e);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(hidden=true, value="Get the message TTL for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getNamespaceMessageTTL(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(NamespaceName.get((String)property, (String)namespace), PolicyName.TTL, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.message_ttl_in_seconds))).exceptionally(ex -> {
            log.error("Failed to get namespace message TTL for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(hidden=true, value="Set message TTL in seconds for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid TTL")})
    public void setNamespaceMessageTTL(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int messageTTL) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetNamespaceMessageTTLAsync(messageTTL).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("Failed to set namespace message TTL for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(value="Remove message TTL in seconds for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid TTL")})
    public void removeNamespaceMessageTTL(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetNamespaceMessageTTLAsync(null).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("Failed to remove namespace message TTL for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Get the subscription expiration time for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getSubscriptionExpirationTime(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(property).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.subscription_expiration_time_minutes))).exceptionally(ex -> {
            log.error("[{}] Failed to get subscription expiration time for namespace {}: {} ", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Set subscription expiration time in minutes for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid expiration time")})
    public void setSubscriptionExpirationTime(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int expirationTime) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetSubscriptionExpirationTimeAsync(expirationTime).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to set subscription expiration time for namespace {}: {} ", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Remove subscription expiration time for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void removeSubscriptionExpirationTime(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetSubscriptionExpirationTimeAsync(null).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to remove subscription expiration time for namespace {}: {} ", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Set anti-affinity group for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid antiAffinityGroup")})
    public void setNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, String antiAffinityGroup) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceAntiAffinityGroup(antiAffinityGroup);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Get anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public String getNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetNamespaceAntiAffinityGroup();
    }

    @GET
    @Path(value="{cluster}/antiAffinity/{group}")
    @ApiOperation(value="Get all namespaces that are grouped by given anti-affinity group in a given cluster. api can be only accessed by admin of any of the existing property")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=412, message="Cluster not exist/Anti-affinity group can't be empty.")})
    public List<String> getAntiAffinityNamespaces(@PathParam(value="cluster") String cluster, @PathParam(value="group") String antiAffinityGroup, @QueryParam(value="property") String property) {
        return this.internalGetAntiAffinityNamespaces(cluster, antiAffinityGroup, property);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Remove anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRemoveNamespaceAntiAffinityGroup();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/deduplication")
    @ApiOperation(hidden=true, value="Enable or disable broker side deduplication for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void modifyDeduplication(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, boolean enableDeduplication) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalModifyDeduplicationAsync(enableDeduplication).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("Failed to modify broker deduplication config for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Get autoTopicCreation info in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void getAutoTopicCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetAutoTopicCreationAsync().thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("Failed to get autoTopicCreation info for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Override broker's allowAutoTopicCreation setting for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=406, message="The number of partitions should be less than or equal to maxNumPartitionsPerPartitionedTopic"), @ApiResponse(code=400, message="Invalid autoTopicCreation override")})
    public void setAutoTopicCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, AutoTopicCreationOverride autoTopicCreationOverride) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetAutoTopicCreationAsync(autoTopicCreationOverride).thenAccept(__ -> {
            String autoOverride = autoTopicCreationOverride != null && autoTopicCreationOverride.isAllowAutoTopicCreation() ? "enabled" : "disabled";
            log.info("[{}] Successfully {} autoTopicCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(e -> {
            Throwable ex = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("[{}] Failed to set autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            if (ex instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Remove override of broker's allowAutoTopicCreation in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void removeAutoTopicCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetAutoTopicCreationAsync(null).thenAccept(__ -> {
            log.info("[{}] Successfully remove autoTopicCreation on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(e -> {
            Throwable ex = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("[{}] Failed to remove autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            if (ex instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Override broker's allowAutoSubscriptionCreation setting for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=400, message="Invalid autoSubscriptionCreation override")})
    public void setAutoSubscriptionCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetAutoSubscriptionCreationAsync(autoSubscriptionCreationOverride).thenAccept(__ -> {
            log.info("[{}] Successfully set autoSubscriptionCreation on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(e -> {
            Throwable ex = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("[{}] Failed to set autoSubscriptionCreation on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            if (ex instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Get autoSubscriptionCreation info in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getAutoSubscriptionCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetAutoSubscriptionCreationAsync().thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(e -> {
            Throwable ex = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("Failed to get autoSubscriptionCreation for namespace {}", (Object)this.namespaceName, (Object)ex);
            if (ex instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Remove override of broker's allowAutoSubscriptionCreation in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void removeAutoSubscriptionCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetAutoSubscriptionCreationAsync(null).thenAccept(__ -> {
            log.info("[{}] Successfully set autoSubscriptionCreation on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(e -> {
            Throwable ex = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("[{}] Failed to remove autoSubscriptionCreation on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            if (ex instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/bundles")
    @ApiOperation(hidden=true, value="Get the bundles split data.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not setup to split in bundles")})
    public void getBundlesData(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validatePoliciesReadOnlyAccessAsync().thenCompose(__ -> this.validateNamespaceOperationAsync(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_BUNDLE))).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.bundles))).exceptionally(ex -> {
            log.error("[{}] Failed to get bundle data for namespace {} ", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/unload")
    @ApiOperation(hidden=true, value="Unload namespace", notes="Unload an active namespace from the current broker serving it. Performing this operation will let the brokerremoves all producers, consumers, and connections using this namespace, and close all topics (includingtheir persistent store). During that operation, the namespace is marked as tentatively unavailable until thebroker completes the unloading action. This operation requires strictly super user privileges, since it wouldresult in non-persistent message loss and unexpected connection closure to the clients.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is already unloaded or Namespace has bundles activated")})
    public void unloadNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        ((CompletableFuture)this.internalUnloadNamespaceAsync().thenAccept(__ -> {
            log.info("[{}] Successfully unloaded all the bundles in namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            }
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/unload")
    @ApiOperation(hidden=true, value="Unload a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=403, message="Don't have admin permission")})
    public void unloadNamespaceBundle(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="destinationBroker") String destinationBroker) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalUnloadNamespaceBundleAsync(bundleRange, destinationBroker, authoritative).thenAccept(__ -> {
            log.info("[{}] Successfully unloaded namespace bundle {}", (Object)this.clientAppId(), (Object)bundleRange);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] Failed to unload namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, ex});
            }
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/split")
    @ApiOperation(hidden=true, value="Split a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=403, message="Don't have admin permission")})
    public void splitNamespaceBundle(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="unload") @DefaultValue(value="false") boolean unload, @QueryParam(value="splitAlgorithmName") String splitAlgorithmName, @ApiParam(value="splitBoundaries") List<Long> splitBoundaries) {
        this.validateNamespaceName(property, cluster, namespace);
        if (StringUtils.isEmpty((CharSequence)splitAlgorithmName)) {
            splitAlgorithmName = "range_equally_divide";
        }
        ((CompletableFuture)this.internalSplitNamespaceBundleAsync(bundleRange, authoritative, unload, splitAlgorithmName, splitBoundaries).thenAccept(__ -> {
            log.info("[{}] Successfully split namespace bundle {}", (Object)this.clientAppId(), (Object)bundleRange);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable realCause;
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] Failed to split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, ex});
            }
            if ((realCause = FutureUtil.unwrapCompletionException((Throwable)ex)) instanceof IllegalArgumentException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Split bundle failed due to invalid request")));
            } else {
                Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            }
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/topicHashPositions")
    @ApiOperation(value="Get hash positions for topics")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getTopicHashPositions(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundle, @QueryParam(value="topics") List<String> topics, @Suspended AsyncResponse asyncResponse) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetTopicHashPositionsAsync(bundle, topics).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            if (!Namespaces.isRedirectException(ex)) {
                log.error("[{}] {} Failed to get topic list for bundle {}.", new Object[]{this.clientAppId(), this.namespaceName, bundle});
            }
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/publishRate")
    @ApiOperation(hidden=true, value="Set publish-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setPublishRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, PublishRate publishRate) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetPublishRateAsync(publishRate).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/publishRate")
    @ApiOperation(hidden=true, value="Get publish-rate configured for the namespace, null means publish-rate not configured, -1 means msg-publish-rate or byte-publish-rate not configured in publish-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getPublishRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetPublishRateAsync().thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("Failed to get publish rate for namespace {}", (Object)this.namespaceName, ex);
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/dispatchRate")
    @ApiOperation(hidden=true, value="Set dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetTopicDispatchRateAsync(dispatchRate).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to update the dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/dispatchRate")
    @ApiOperation(hidden=true, value="Get dispatch-rate configured for the namespace, null means dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume(policies.topicDispatchRate.get(this.pulsar().getConfiguration().getClusterName())))).exceptionally(ex -> {
            log.error("[{}] Failed to get dispatch-rate configured for the namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Set Subscription dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetSubscriptionDispatchRateAsync(dispatchRate).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to set the subscription dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Get subscription dispatch-rate configured for the namespace, null means subscription dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetSubscriptionDispatchRateAsync().thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get the subscription dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Delete subscription dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void deleteSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalDeleteSubscriptionDispatchRateAsync().thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to delete the subscription dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{cluster}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Set replicator dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setReplicatorDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @ApiParam(value="Replicator dispatch rate for all topics of the specified namespace") DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(tenant, cluster, namespace);
        this.internalSetReplicatorDispatchRate(asyncResponse, dispatchRate);
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Get replicator dispatch-rate configured for the namespace, null means replicator dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getReplicatorDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, cluster, namespace);
        this.internalGetReplicatorDispatchRate(asyncResponse);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuotaMap")
    @ApiOperation(hidden=true, value="Get backlog quota map on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getBacklogQuotaMap(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalGetBacklogQuotaMap(asyncResponse);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuota")
    @ApiOperation(hidden=true, value=" Set a backlog quota for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Specified backlog quota exceeds retention quota. Increase retention quota and retry request")})
    public void setBacklogQuota(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetBacklogQuota(asyncResponse, backlogQuotaType, backlogQuota);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuota")
    @ApiOperation(hidden=true, value="Remove a backlog quota policy from a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeBacklogQuota(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRemoveBacklogQuota(asyncResponse, backlogQuotaType);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/retention")
    @ApiOperation(hidden=true, value="Get retention config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getRetention(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RETENTION, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.retention_policies))).exceptionally(ex -> {
            log.error("[{}] Failed to get retention config on a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/retention")
    @ApiOperation(hidden=true, value=" Set retention configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Retention Quota must exceed backlog quota")})
    public void setRetention(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, RetentionPolicies retention) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetRetention(retention);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/persistence")
    @ApiOperation(hidden=true, value="Set the persistence configuration for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=400, message="Invalid persistence policies")})
    public void setPersistence(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, PersistencePolicies persistence) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetPersistenceAsync(persistence).thenAccept(__ -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to update the persistence for a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Set the bookie-affinity-group to namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetBookieAffinityGroup(bookieAffinityGroup);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Get the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public BookieAffinityGroupData getBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetBookieAffinityGroup();
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Delete the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void deleteBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalDeleteBookieAffinityGroup();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/persistence")
    @ApiOperation(hidden=true, value="Get the persistence configuration for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getPersistence(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.persistence))).exceptionally(ex -> {
            log.error("[{}] Failed to get persistence configuration for a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/clearBacklog")
    @ApiOperation(hidden=true, value="Clear backlog for all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklog(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalClearNamespaceBacklog(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/clearBacklog")
    @ApiOperation(hidden=true, value="Clear backlog for all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklog(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalClearNamespaceBundleBacklog(bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/clearBacklog/{subscription}")
    @ApiOperation(hidden=true, value="Clear backlog for a given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklogForSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalClearNamespaceBacklogForSubscription(asyncResponse, subscription, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/clearBacklog/{subscription}")
    @ApiOperation(hidden=true, value="Clear backlog for a given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklogForSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalClearNamespaceBundleBacklogForSubscription(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/unsubscribe/{subscription}")
    @ApiOperation(hidden=true, value="Unsubscribes the given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalUnsubscribeNamespace(asyncResponse, subscription, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/unsubscribe/{subscription}")
    @ApiOperation(hidden=true, value="Unsubscribes the given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespaceBundle(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalUnsubscribeNamespaceBundle(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionAuthMode")
    @ApiOperation(value=" Set a subscription auth mode for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSubscriptionAuthMode(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetSubscriptionAuthMode(subscriptionAuthMode);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionAuthMode")
    @ApiOperation(value="Get subscription auth mode in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getSubscriptionAuthMode(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.subscription_auth_mode))).exceptionally(ex -> {
            log.error("[{}] Failed to get subscription auth mode in a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/encryptionRequired")
    @ApiOperation(hidden=true, value="Message encryption is required or not for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void modifyEncryptionRequired(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, boolean encryptionRequired) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalModifyEncryptionRequired(encryptionRequired);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/encryptionRequired")
    @ApiOperation(value="Get message encryption required status in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public Boolean getEncryptionRequired(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(property);
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetEncryptionRequired();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value="Get maxProducersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getMaxProducersPerTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.max_producers_per_topic))).exceptionally(ex -> {
            log.error("[{}] Failed to get maxProducersPerTopic config on a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value=" Set maxProducersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxProducersPerTopic value is not valid")})
    public void setMaxProducersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxProducersPerTopic) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxProducersPerTopic(maxProducersPerTopic);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value="Get maxConsumersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getMaxConsumersPerTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.max_consumers_per_topic))).exceptionally(ex -> {
            log.error("[{}] Failed to get maxConsumersPerTopic config on a namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value=" Set maxConsumersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerTopic value is not valid")})
    public void setMaxConsumersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxConsumersPerTopic) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerTopic(maxConsumersPerTopic);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value="Get maxConsumersPerSubscription config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getMaxConsumersPerSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(polices -> asyncResponse.resume((Object)polices.max_consumers_per_subscription))).exceptionally(ex -> {
            log.error("[{}] Failed to get maxConsumersPerSubscription config on namespace {}: {} ", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value=" Set maxConsumersPerSubscription configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerSubscription value is not valid")})
    public void setMaxConsumersPerSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxConsumersPerSubscription) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerSubscription(maxConsumersPerSubscription);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value="Remove maxConsumersPerSubscription configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxConsumersPerSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerSubscription(null);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/compactionThreshold")
    @ApiOperation(value="Maximum number of uncompacted bytes in topics before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public void getCompactionThreshold(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.compaction_threshold))).exceptionally(ex -> {
            log.error("[{}] Failed to get compaction threshold on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/compactionThreshold")
    @ApiOperation(value="Set maximum number of uncompacted bytes in a topic before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="compactionThreshold value is not valid")})
    public void setCompactionThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetCompactionThreshold(newThreshold);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/offloadThreshold")
    @ApiOperation(value="Maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public void getOffloadThreshold(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> {
            if (policies.offload_policies == null) {
                asyncResponse.resume((Object)policies.offload_threshold);
            } else {
                asyncResponse.resume((Object)policies.offload_policies.getManagedLedgerOffloadThresholdInBytes());
            }
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get offload threshold on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            Namespaces.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/offloadThreshold")
    @ApiOperation(value="Set maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="offloadThreshold value is not valid")})
    public void setOffloadThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetOffloadThreshold(newThreshold);
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="The strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, cluster, namespace);
        return this.internalGetSchemaAutoUpdateCompatibilityStrategy();
    }

    @PUT
    @Path(value="/{tenant}/{cluster}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="Update the strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespaceName(tenant, cluster, namespace);
        this.internalSetSchemaAutoUpdateCompatibilityStrategy(strategy);
    }
}

