/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataNodeSizeStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataNodeSizeStats
implements MetadataNodeSizeStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetadataNodeSizeStats.class);
    public static final int UNSET = -1;
    private static final SplitPathRes MEANINGLESS_SPLIT_PATH_RES = new SplitPathRes();
    private static final FastThreadLocal<SplitPathRes> LOCAL_SPLIT_PATH_RES = new FastThreadLocal<SplitPathRes>(){

        protected SplitPathRes initialValue() {
            return new SplitPathRes();
        }
    };
    private final AtomicReferenceArray<Integer> maxSizeMapping;
    private final AtomicReferenceArray<Integer> maxChildrenCountMapping;

    public DefaultMetadataNodeSizeStats() {
        int pathTypeCount = PathType.values().length;
        this.maxSizeMapping = new AtomicReferenceArray(pathTypeCount);
        this.maxChildrenCountMapping = new AtomicReferenceArray(pathTypeCount);
        for (int i = 0; i < pathTypeCount; ++i) {
            this.maxSizeMapping.set(i, -1);
            this.maxChildrenCountMapping.set(i, -1);
        }
    }

    public void recordPut(String path, byte[] data) {
        PathType pathType = this.getPathType(path);
        if (pathType == PathType.UNKNOWN) {
            return;
        }
        this.maxSizeMapping.set(pathType.ordinal(), Math.max(this.maxSizeMapping.get(pathType.ordinal()), data.length));
    }

    public void recordGetRes(String path, GetResult getResult) {
        PathType pathType = this.getPathType(path);
        if (pathType == PathType.UNKNOWN || getResult == null) {
            return;
        }
        this.maxSizeMapping.set(pathType.ordinal(), Math.max(this.maxSizeMapping.get(pathType.ordinal()), getResult.getValue().length));
    }

    public void recordGetChildrenRes(String path, List<String> list) {
        PathType pathType = this.getPathType(path);
        if (pathType == PathType.UNKNOWN) {
            return;
        }
        int size = CollectionUtils.isEmpty(list) ? 0 : list.size();
        this.maxChildrenCountMapping.set(pathType.ordinal(), Math.max(this.maxChildrenCountMapping.get(pathType.ordinal()), size));
    }

    public int getMaxSizeOfSameResourceType(String path) {
        PathType pathType = this.getPathType(path);
        if (pathType == PathType.UNKNOWN) {
            return -1;
        }
        return this.maxSizeMapping.get(pathType.ordinal());
    }

    public int getMaxChildrenCountOfSameResourceType(String path) {
        PathType pathType = this.getPathType(path);
        if (pathType == PathType.UNKNOWN) {
            return -1;
        }
        return this.maxChildrenCountMapping.get(pathType.ordinal());
    }

    private PathType getPathType(String path) {
        SplitPathRes splitPathRes = DefaultMetadataNodeSizeStats.splitPath(path);
        if (splitPathRes.partCount < 2) {
            return PathType.UNKNOWN;
        }
        return switch (splitPathRes.parts[0]) {
            case "admin" -> this.getAdminPathType(splitPathRes);
            case "managed-ledgers" -> this.getMlPathType(splitPathRes);
            case "loadbalance" -> this.getLoadBalancePathType(splitPathRes);
            case "namespace" -> this.getBundleOwnerPathType(splitPathRes);
            case "schemas" -> this.getSchemaPathType(splitPathRes);
            default -> PathType.UNKNOWN;
        };
    }

    private PathType getAdminPathType(SplitPathRes splitPathRes) {
        return switch (splitPathRes.parts[1]) {
            case "clusters" -> PathType.CLUSTER;
            case "policies" -> {
                switch (splitPathRes.partCount) {
                    case 3: {
                        yield PathType.TENANT;
                    }
                    case 4: {
                        yield PathType.NAMESPACE_POLICIES;
                    }
                }
                yield PathType.UNKNOWN;
            }
            case "local-policies" -> {
                switch (splitPathRes.partCount) {
                    case 4: {
                        yield PathType.NAMESPACE_POLICIES;
                    }
                }
                yield PathType.UNKNOWN;
            }
            case "partitioned-topics" -> {
                switch (splitPathRes.partCount) {
                    case 5: {
                        yield PathType.PARTITIONED_NAMESPACE;
                    }
                    case 6: {
                        yield PathType.PARTITIONED_TOPIC;
                    }
                }
                yield PathType.UNKNOWN;
            }
            default -> PathType.UNKNOWN;
        };
    }

    private PathType getBundleOwnerPathType(SplitPathRes splitPathRes) {
        return switch (splitPathRes.partCount) {
            case 3 -> PathType.BUNDLE_OWNER_NAMESPACE;
            case 4 -> PathType.BUNDLE_OWNER;
            default -> PathType.UNKNOWN;
        };
    }

    private PathType getSchemaPathType(SplitPathRes splitPathRes) {
        if (splitPathRes.partCount == 4) {
            return PathType.TOPIC_SCHEMA;
        }
        return PathType.UNKNOWN;
    }

    private PathType getLoadBalancePathType(SplitPathRes splitPathRes) {
        return switch (splitPathRes.parts[1]) {
            case "brokers" -> {
                switch (splitPathRes.partCount) {
                    case 2: {
                        yield PathType.BROKERS;
                    }
                    case 3: {
                        yield PathType.BROKER;
                    }
                }
                yield PathType.UNKNOWN;
            }
            case "bundle-data" -> {
                switch (splitPathRes.partCount) {
                    case 4: {
                        yield PathType.BUNDLE_NAMESPACE;
                    }
                    case 5: {
                        yield PathType.BUNDLE_DATA;
                    }
                }
                yield PathType.UNKNOWN;
            }
            case "broker-time-average" -> {
                switch (splitPathRes.partCount) {
                    case 3: {
                        yield PathType.BROKER_TIME_AVERAGE;
                    }
                }
                yield PathType.UNKNOWN;
            }
            case "leader" -> PathType.BROKER_LEADER;
            default -> PathType.UNKNOWN;
        };
    }

    private PathType getMlPathType(SplitPathRes splitPathRes) {
        return switch (splitPathRes.partCount) {
            case 4 -> PathType.ML_NAMESPACE;
            case 5 -> PathType.TOPIC;
            case 6 -> PathType.SUBSCRIPTION;
            case 7 -> PathType.SUBSCRIPTION;
            default -> PathType.UNKNOWN;
        };
    }

    static SplitPathRes splitPath(String path) {
        if (path == null || path.length() <= 1) {
            return MEANINGLESS_SPLIT_PATH_RES;
        }
        SplitPathRes res = (SplitPathRes)LOCAL_SPLIT_PATH_RES.get();
        res.reset();
        String[] parts = res.parts;
        char delimiter = '/';
        int length = path.length();
        int start = 0;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (path.charAt(i) != delimiter) continue;
            if (start == i) {
                start = i + 1;
                continue;
            }
            if (count < 2) {
                parts[count] = path.substring(start, i);
            }
            start = i + 1;
            ++count;
        }
        if (start < length) {
            if (count < 2) {
                parts[count] = path.substring(start);
            }
            ++count;
        }
        res.partCount = count;
        return res;
    }

    static enum PathType {
        CLUSTER,
        TENANT,
        NAMESPACE_POLICIES,
        LOCAL_POLICIES,
        BROKERS,
        BROKER,
        BROKER_LEADER,
        BUNDLE_NAMESPACE,
        BUNDLE_DATA,
        BROKER_TIME_AVERAGE,
        BUNDLE_OWNER_NAMESPACE,
        BUNDLE_OWNER,
        TOPIC_SCHEMA,
        PARTITIONED_TOPIC,
        PARTITIONED_NAMESPACE,
        ML_NAMESPACE,
        TOPIC,
        SUBSCRIPTION,
        UNKNOWN;

    }

    static class SplitPathRes {
        String[] parts = new String[2];
        int partCount;

        SplitPathRes() {
        }

        void reset() {
            this.parts[0] = null;
            this.parts[1] = null;
            this.partCount = 0;
        }
    }
}

