/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;

public final class IntegerType
extends AbstractIntType {
    public static final IntegerType INTEGER = new IntegerType();

    private IntegerType() {
        super(new TypeSignature("integer", new TypeSignatureParameter[0]));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getInt(position, 0);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @Override
    public boolean equals(Object other) {
        return other == INTEGER;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

