/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.testing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.testing.ConfigAssertions$$;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class ConfigAssertions {
    private static final Method GET_RECORDING_CONFIG_METHOD;

    private ConfigAssertions() {
    }

    public static <T> void assertDefaults(Map<String, Object> expectedAttributeValues, Class<T> configClass) {
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        if (!metadata.getAttributes().keySet().containsAll(expectedAttributeValues.keySet())) {
            TreeSet<String> unsupportedAttributes = new TreeSet<String>(expectedAttributeValues.keySet());
            unsupportedAttributes.removeAll(metadata.getAttributes().keySet());
            throw new AssertionError((Object)("Unsupported attributes: " + unsupportedAttributes));
        }
        TreeSet<String> nonDeprecatedAttributes = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() == null) continue;
            nonDeprecatedAttributes.add(attribute.getName());
        }
        if (!nonDeprecatedAttributes.containsAll(expectedAttributeValues.keySet())) {
            TreeSet<String> unsupportedAttributes = new TreeSet<String>(expectedAttributeValues.keySet());
            unsupportedAttributes.removeAll(nonDeprecatedAttributes);
            throw new AssertionError((Object)("Deprecated attributes: " + unsupportedAttributes));
        }
        if (!expectedAttributeValues.keySet().containsAll(nonDeprecatedAttributes)) {
            TreeSet untestedAttributes = new TreeSet(nonDeprecatedAttributes);
            untestedAttributes.removeAll(expectedAttributeValues.keySet());
            throw new AssertionError((Object)("Untested attributes: " + untestedAttributes));
        }
        T actual = ConfigAssertions.newDefaultInstance(configClass);
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Object expectedAttributeValue;
            Object actualAttributeValue;
            Method getter = attribute.getGetter();
            if (getter != null && !Objects.deepEquals(actualAttributeValue = ConfigAssertions.invoke(actual, getter), expectedAttributeValue = expectedAttributeValues.get(attribute.getName()))) {
                throw new AssertionError((Object)ConfigAssertions.notEquals(attribute.getName(), actualAttributeValue, expectedAttributeValue));
            }
        }
    }

    public static <T> void assertFullMapping(Map<String, String> properties, T expected) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(expected, "expected");
        Class<T> configClass = ConfigAssertions.getClass(expected);
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, properties.keySet(), false);
        TreeSet<String> nonDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() == null) continue;
            nonDeprecatedProperties.add(attribute.getInjectionPoint().getProperty());
        }
        if (!properties.keySet().equals(nonDeprecatedProperties)) {
            TreeSet untestedProperties = new TreeSet(nonDeprecatedProperties);
            untestedProperties.removeAll(properties.keySet());
            throw new AssertionError((Object)("Untested properties " + untestedProperties));
        }
        T actual = ConfigAssertions.newInstance(configClass, properties);
        T defaultInstance = ConfigAssertions.newDefaultInstance(configClass);
        ConfigAssertions.assertAttributesNotEqual(metadata, actual, defaultInstance);
        ConfigAssertions.assertAttributesEqual(metadata, actual, expected);
    }

    @SafeVarargs
    public static <T> void assertDeprecatedEquivalence(Class<T> configClass, Map<String, String> currentProperties, Map<String, String> ... oldPropertiesList) {
        Objects.requireNonNull(configClass, "configClass");
        Objects.requireNonNull(currentProperties, "currentProperties");
        Objects.requireNonNull(oldPropertiesList, "oldPropertiesList");
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, currentProperties.keySet(), false);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            ConfigAssertions.assertPropertiesSupported(metadata, evenOlderProperties.keySet(), true);
        }
        TreeSet<String> knownDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                knownDeprecatedProperties.add(deprecated.getProperty());
            }
        }
        TreeSet<String> suppliedDeprecatedProperties = new TreeSet<String>();
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            suppliedDeprecatedProperties.addAll(evenOlderProperties.keySet());
        }
        if (!suppliedDeprecatedProperties.containsAll(knownDeprecatedProperties)) {
            TreeSet untestedDeprecatedProperties = new TreeSet(knownDeprecatedProperties);
            untestedDeprecatedProperties.removeAll(suppliedDeprecatedProperties);
            throw new AssertionError((Object)("Untested deprecated properties: " + untestedDeprecatedProperties));
        }
        T currentConfiguration = ConfigAssertions.newInstance(configClass, currentProperties);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            T evenOlderConfiguration = ConfigAssertions.newInstance(configClass, evenOlderProperties);
            ConfigAssertions.assertAttributesEqual(metadata, currentConfiguration, evenOlderConfiguration);
        }
    }

    private static void assertPropertiesSupported(ConfigurationMetadata<?> metadata, Set<String> propertyNames, boolean allowDeprecatedProperties) {
        TreeSet<String> supportedProperties = new TreeSet<String>();
        TreeSet<String> nonDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() != null) {
                nonDeprecatedProperties.add(attribute.getInjectionPoint().getProperty());
                supportedProperties.add(attribute.getInjectionPoint().getProperty());
            }
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                supportedProperties.add(deprecated.getProperty());
            }
        }
        if (!supportedProperties.containsAll(propertyNames)) {
            TreeSet<String> unsupportedProperties = new TreeSet<String>(propertyNames);
            unsupportedProperties.removeAll(supportedProperties);
            throw new AssertionError((Object)("Unsupported properties: " + unsupportedProperties));
        }
        if (!allowDeprecatedProperties && !nonDeprecatedProperties.containsAll(propertyNames)) {
            TreeSet<String> deprecatedProperties = new TreeSet<String>(propertyNames);
            deprecatedProperties.removeAll(nonDeprecatedProperties);
            throw new AssertionError((Object)("Deprecated properties: " + deprecatedProperties));
        }
    }

    private static <T> void assertAttributesEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Object expectedAttributeValue;
            Object actualAttributeValue;
            Method getter = attribute.getGetter();
            if (getter != null && !Objects.deepEquals(actualAttributeValue = ConfigAssertions.invoke(actual, getter), expectedAttributeValue = ConfigAssertions.invoke(expected, getter))) {
                throw new AssertionError((Object)ConfigAssertions.notEquals(attribute.getName(), actualAttributeValue, expectedAttributeValue));
            }
        }
    }

    private static <T> void assertAttributesNotEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Object expectedAttributeValue;
            Object actualAttributeValue;
            Method getter = attribute.getGetter();
            if (getter != null && Objects.deepEquals(actualAttributeValue = ConfigAssertions.invoke(actual, getter), expectedAttributeValue = ConfigAssertions.invoke(expected, getter))) {
                throw new AssertionError((Object)("Attribute value matches the default: " + attribute.getName()));
            }
        }
    }

    public static <T> void assertRecordedDefaults(T recordedConfig) {
        $$RecordedConfigData<T> recordedConfigData = ConfigAssertions.getRecordedConfig(recordedConfig);
        Set<Method> invokedMethods = recordedConfigData.getInvokedMethods();
        T config = recordedConfigData.getInstance();
        Class<T> configClass = ConfigAssertions.getClass(config);
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        TreeMap<String, Object> attributeValues = new TreeMap<String, Object>();
        TreeSet<String> setDeprecatedAttributes = new TreeSet<String>();
        HashSet<Method> validSetterMethods = new HashSet<Method>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() != null) {
                validSetterMethods.add(attribute.getInjectionPoint().getSetter());
            }
            if (!invokedMethods.contains(attribute.getInjectionPoint().getSetter())) continue;
            if (attribute.getInjectionPoint().getProperty() != null) {
                Object value = ConfigAssertions.invoke(config, attribute.getGetter());
                attributeValues.put(attribute.getName(), value);
                continue;
            }
            setDeprecatedAttributes.add(attribute.getName());
        }
        if (!setDeprecatedAttributes.isEmpty()) {
            throw new AssertionError((Object)("Invoked deprecated attribute setter methods: " + setDeprecatedAttributes));
        }
        if (!validSetterMethods.containsAll(invokedMethods)) {
            HashSet<Method> invalidInvocations = new HashSet<Method>(invokedMethods);
            invalidInvocations.removeAll(validSetterMethods);
            throw new AssertionError((Object)("Invoked non-attribute setter methods: " + invalidInvocations));
        }
        ConfigAssertions.assertDefaults(attributeValues, configClass);
    }

    public static <T> T recordDefaults(Class<T> type) {
        Class loaded = new ByteBuddy().subclass(type).implement(new Type[]{$$RecordingConfigProxy.class}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)ConfigAssertions.createInvocationHandler(type)).make().load(type.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        try {
            return loaded.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Failed to instantiate proxy class for " + type.getName(), e);
        }
    }

    private static <T> InvocationHandlerAdapter createInvocationHandler(Class<T> type) {
        Object instance = ConfigAssertions.newDefaultInstance(type);
        Set invokedMethods = Sets.newConcurrentHashSet();
        return InvocationHandlerAdapter.of((proxy, method, args) -> {
            if (GET_RECORDING_CONFIG_METHOD.equals(method)) {
                return new $$RecordedConfigData<Object>(instance, (Set<Method>)ImmutableSet.copyOf((Collection)invokedMethods));
            }
            invokedMethods.add(method);
            Object result = method.invoke(instance, args);
            if (result == instance) {
                return proxy;
            }
            return result;
        });
    }

    static <T> $$RecordedConfigData<T> getRecordedConfig(T config) {
        if (!(config instanceof $$RecordingConfigProxy)) {
            throw new IllegalArgumentException("Configuration was not created with the recordDefaults method");
        }
        return (($$RecordingConfigProxy)config).$$getRecordedConfig();
    }

    private static <T> Class<T> getClass(T object) {
        return object.getClass();
    }

    private static <T> T newInstance(Class<T> configClass, Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        return configurationFactory.build(configClass);
    }

    private static <T> T newDefaultInstance(Class<T> configClass) {
        try {
            return configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Exception creating default instance of " + configClass.getName(), e);
        }
    }

    private static <T> Object invoke(T actual, Method getter) {
        try {
            return getter.invoke(actual, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Exception invoking " + getter.toGenericString(), e);
        }
    }

    private static String notEquals(String message, Object actual, Object expected) {
        return String.format("%s expected [%s] but found [%s]", message, expected, actual);
    }

    static {
        try {
            GET_RECORDING_CONFIG_METHOD = $$RecordingConfigProxy.class.getMethod("$$getRecordedConfig", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

