/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SchemaUtil;
import java.util.Locale;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class SchemaTableName {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SchemaTableName.class).instanceSize();
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public SchemaTableName(@JsonProperty(value="schema") String schemaName, @JsonProperty(value="table") String tableName) {
        this.schemaName = SchemaUtil.checkNotEmpty(schemaName, "schemaName").toLowerCase(Locale.ENGLISH);
        this.tableName = SchemaUtil.checkNotEmpty(tableName, "tableName").toLowerCase(Locale.ENGLISH);
    }

    public static SchemaTableName schemaTableName(String schemaName, String tableName) {
        return new SchemaTableName(schemaName, tableName);
    }

    @JsonProperty(value="schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="table")
    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTableName other = (SchemaTableName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }

    public SchemaTablePrefix toSchemaTablePrefix() {
        return new SchemaTablePrefix(this.schemaName, this.tableName);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.schemaName) + SizeOf.estimatedSizeOf((String)this.tableName);
    }
}

