/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.instruction.Constant;
import java.util.List;

class ConstantBytecodeExpression
extends BytecodeExpression {
    private final Constant value;

    public ConstantBytecodeExpression(Class<?> type, Constant value) {
        this(ParameterizedType.type(type), value);
    }

    public ConstantBytecodeExpression(ParameterizedType type, Constant value) {
        super(type);
        this.value = value;
    }

    @Override
    public Constant getBytecode(MethodGenerationContext generationContext) {
        return this.value;
    }

    @Override
    protected String formatOneLine() {
        return ConstantBytecodeExpression.renderConstant(this.value.getValue());
    }

    public static String renderConstant(Object value) {
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Float) {
            return value + "f";
        }
        if (value instanceof ParameterizedType) {
            return ((ParameterizedType)value).getSimpleName() + ".class";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

