/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.expression.ArithmeticBytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class NegateBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression value;
    private final OpCode negateOpCode;

    NegateBytecodeExpression(BytecodeExpression value) {
        super(Objects.requireNonNull(value, "value is null").getType());
        this.value = value;
        Class<?> type = value.getType().getPrimitiveType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"value is not a primitive");
        Preconditions.checkArgument((type != Void.TYPE ? 1 : 0) != 0, (Object)"value is void");
        Preconditions.checkArgument((type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE ? 1 : 0) != 0, (String)"value argument must be int, long, float, or double, but is %s", type);
        this.negateOpCode = ArithmeticBytecodeExpression.getNumericOpCode("Negate", OpCode.INEG, type);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.value).append(this.negateOpCode);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    protected String formatOneLine() {
        return "-(" + this.value + ")";
    }
}

