/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.ArrayOpCode;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.instruction.InstructionNode;
import java.util.List;
import java.util.Objects;

class SetArrayElementBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final BytecodeExpression index;
    private final BytecodeExpression value;
    private final InstructionNode arrayStoreInstruction;

    public SetArrayElementBytecodeExpression(BytecodeExpression instance, BytecodeExpression index, BytecodeExpression value) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.value = Objects.requireNonNull(value, "value is null");
        ParameterizedType componentType = instance.getType().getArrayComponentType();
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        Preconditions.checkArgument((boolean)componentType.equals(value.getType()), (String)"value must be %s type, but is %s", (Object)componentType, (Object)value.getType());
        this.arrayStoreInstruction = ArrayOpCode.getArrayOpCode(componentType).getStore();
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.index).append(this.value).append(this.arrayStoreInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "] = " + this.value;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.index, (Object)this.value);
    }
}

