/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.UpdateSketch;

final class HeapCompactSketch
extends CompactSketch {
    private final long[] cache_;

    private HeapCompactSketch(boolean empty, short seedHash, int curCount, long thetaLong, long[] cache) {
        super(empty, seedHash, curCount, thetaLong);
        this.cache_ = cache;
    }

    static HeapCompactSketch heapifyInstance(Memory srcMem, long seed) {
        long pre0 = srcMem.getLong(0L);
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        boolean empty = (flags & 4) > 0;
        short memSeedHash = (short)PreambleUtil.extractSeedHash(pre0);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        int curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
        long thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        long[] cacheArr = new long[curCount];
        if (curCount > 0) {
            srcMem.getLongArray((long)(preLongs << 3), cacheArr, 0, curCount);
        }
        HeapCompactSketch hcs = new HeapCompactSketch(empty, memSeedHash, curCount, thetaLong, cacheArr);
        return hcs;
    }

    HeapCompactSketch(UpdateSketch sketch) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        boolean ordered = false;
        this.cache_ = CompactSketch.compactCache(sketch.getCache(), this.getRetainedEntries(false), this.getThetaLong(), false);
    }

    HeapCompactSketch(long[] compactCache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
        assert (compactCache != null);
        this.cache_ = curCount == 0 ? new long[]{} : compactCache;
    }

    @Override
    public byte[] toByteArray() {
        int bytes = this.getCurrentBytes(true);
        byte[] byteArray = new byte[bytes];
        NativeMemory dstMem = new NativeMemory(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8);
        HeapCompactSketch.loadCompactMemory(this.getCache(), this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), (Memory)dstMem, flags);
        return byteArray;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

