/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.impl;

import com.scurrilous.circe.Hash;
import com.scurrilous.circe.HashParameters;
import com.scurrilous.circe.HashProvider;
import com.scurrilous.circe.HashSupport;
import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.IncrementalLongHash;
import com.scurrilous.circe.StatefulHash;
import com.scurrilous.circe.StatefulIntHash;
import com.scurrilous.circe.StatefulLongHash;
import com.scurrilous.circe.StatelessHash;
import com.scurrilous.circe.StatelessIntHash;
import com.scurrilous.circe.StatelessLongHash;
import com.scurrilous.circe.impl.HashCache;
import com.scurrilous.circe.impl.HashCacheLoader;
import com.scurrilous.circe.impl.IntStatelessLongHash;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public abstract class AbstractHashProvider<P extends HashParameters>
implements HashProvider {
    private final Class<P> parametersClass;

    protected AbstractHashProvider(Class<P> parametersClass) {
        this.parametersClass = parametersClass;
    }

    @Override
    public final EnumSet<HashSupport> querySupport(HashParameters params) {
        if (!this.parametersClass.isAssignableFrom(params.getClass())) {
            return EnumSet.noneOf(HashSupport.class);
        }
        return this.querySupportTyped((HashParameters)this.parametersClass.cast(params));
    }

    protected abstract EnumSet<HashSupport> querySupportTyped(P var1);

    protected abstract Hash get(P var1, EnumSet<HashSupport> var2);

    protected final Hash getCacheable(final P params, final EnumSet<HashSupport> required) {
        if (HashCacheLoader.hasCache()) {
            HashCache cache = HashCacheLoader.getCache();
            try {
                return cache.get((HashParameters)params, required, new Callable<Hash>(){

                    @Override
                    public Hash call() throws Exception {
                        return AbstractHashProvider.this.createCacheable(params, required);
                    }
                });
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new UnsupportedOperationException(e);
            }
        }
        return this.createCacheable(params, required);
    }

    protected StatelessHash createCacheable(P params, EnumSet<HashSupport> required) {
        throw new UnsupportedOperationException();
    }

    private Hash castAndGet(HashParameters params, EnumSet<HashSupport> required) {
        if (!this.parametersClass.isAssignableFrom(params.getClass())) {
            throw new UnsupportedOperationException();
        }
        return this.get((HashParameters)this.parametersClass.cast(params), required);
    }

    @Override
    public StatefulHash createStateful(HashParameters params) {
        Hash hash = this.castAndGet(params, EnumSet.of(HashSupport.STATEFUL));
        if (hash instanceof StatefulHash) {
            return (StatefulHash)hash;
        }
        if (hash instanceof StatelessHash) {
            return ((StatelessHash)hash).createStateful();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StatelessIntHash getStatelessInt(HashParameters params) {
        Hash hash = this.castAndGet(params, EnumSet.of(HashSupport.INT_SIZED));
        if (hash instanceof StatelessIntHash) {
            return (StatelessIntHash)hash;
        }
        if (hash instanceof StatefulIntHash) {
            return ((StatefulIntHash)hash).asStateless();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StatelessLongHash getStatelessLong(HashParameters params) {
        Hash hash = this.castAndGet(params, EnumSet.of(HashSupport.LONG_SIZED));
        if (hash instanceof StatelessLongHash) {
            return (StatelessLongHash)hash;
        }
        if (hash instanceof StatefulLongHash) {
            return ((StatefulLongHash)hash).asStateless();
        }
        if (hash instanceof StatelessIntHash) {
            return new IntStatelessLongHash((StatelessIntHash)hash);
        }
        if (hash instanceof StatefulIntHash) {
            return new IntStatelessLongHash(((StatefulIntHash)hash).asStateless());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IncrementalIntHash getIncrementalInt(HashParameters params) {
        Hash hash = this.castAndGet(params, EnumSet.of(HashSupport.INT_SIZED, HashSupport.STATELESS_INCREMENTAL));
        if (hash instanceof IncrementalIntHash) {
            return (IncrementalIntHash)hash;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IncrementalLongHash getIncrementalLong(HashParameters params) {
        Hash hash = this.castAndGet(params, EnumSet.of(HashSupport.LONG_SIZED, HashSupport.STATELESS_INCREMENTAL));
        if (hash instanceof IncrementalLongHash) {
            return (IncrementalLongHash)hash;
        }
        throw new UnsupportedOperationException();
    }
}

