/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerInterceptors
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProducerInterceptors.class);
    private final List<ProducerInterceptor> interceptors;

    public ProducerInterceptors(List<ProducerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Message beforeSend(Producer producer, Message message) {
        Message interceptorMessage = message;
        for (ProducerInterceptor interceptor : this.interceptors) {
            try {
                if (!interceptor.eligible(message)) continue;
                interceptorMessage = interceptor.beforeSend(producer, interceptorMessage);
            }
            catch (Throwable e) {
                if (producer != null) {
                    log.warn("Error executing interceptor beforeSend callback for topicName:{} ", (Object)producer.getTopic(), (Object)e);
                    continue;
                }
                log.warn("Error Error executing interceptor beforeSend callback ", e);
            }
        }
        return interceptorMessage;
    }

    public void onSendAcknowledgement(Producer producer, Message message, MessageId msgId, Throwable exception) {
        for (ProducerInterceptor interceptor : this.interceptors) {
            try {
                if (!interceptor.eligible(message)) continue;
                interceptor.onSendAcknowledgement(producer, message, msgId, exception);
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onSendAcknowledgement callback ", e);
            }
        }
    }

    public void onPartitionsChange(String topicName, int partitions) {
        for (ProducerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.onPartitionsChange(topicName, partitions);
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onPartitionsChange callback ", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (ProducerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.close();
            }
            catch (Throwable e) {
                log.error("Fail to close producer interceptor ", e);
            }
        }
    }
}

