/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.autorecovery;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAutoRecoveryStatusCommand
extends BookieCommand<QFlags> {
    static final Logger LOG = LoggerFactory.getLogger(QueryAutoRecoveryStatusCommand.class);
    private static final String NAME = "queryautorecoverystatus";
    private static final String DESC = "Query autorecovery status.";

    public QueryAutoRecoveryStatusCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new QFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, QFlags cmdFlags) {
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean handler(ServerConfiguration conf, QFlags flag) throws Exception {
        MetadataDrivers.runFunctionWithLedgerManagerFactory(conf, mFactory -> {
            LedgerUnderreplicationManager underreplicationManager;
            LedgerManager ledgerManager = mFactory.newLedgerManager();
            LinkedList<LedgerRecoverInfo> ledgerList = new LinkedList<LedgerRecoverInfo>();
            try {
                underreplicationManager = mFactory.newLedgerUnderreplicationManager();
            }
            catch (ReplicationException e) {
                throw new UncheckedExecutionException("Failed to new ledger underreplicated manager", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException("Interrupted on newing ledger underreplicated manager", (Throwable)e);
            }
            Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(null);
            while (iter.hasNext()) {
                UnderreplicatedLedger underreplicatedLedger = iter.next();
                long urLedgerId = underreplicatedLedger.getLedgerId();
                try {
                    String replicationWorkerId = underreplicationManager.getReplicationWorkerIdRereplicatingLedger(urLedgerId);
                    if (replicationWorkerId == null) continue;
                    ledgerList.add(new LedgerRecoverInfo(urLedgerId, replicationWorkerId));
                }
                catch (ReplicationException.UnavailableException e) {
                    LOG.error("Failed to get ReplicationWorkerId rereplicating ledger {} -- {}", (Object)urLedgerId, (Object)e.getMessage());
                }
            }
            LOG.info("CurrentRecoverLedgerInfo:");
            if (!flag.verbose.booleanValue()) {
                for (int i = 0; i < ledgerList.size(); ++i) {
                    LOG.info("\tLedgerId:{}\tBookieId:{}", (Object)((LedgerRecoverInfo)ledgerList.get((int)i)).ledgerId, (Object)((LedgerRecoverInfo)ledgerList.get((int)i)).bookieId);
                }
            } else {
                for (int i = 0; i < ledgerList.size(); ++i) {
                    LedgerRecoverInfo info = (LedgerRecoverInfo)ledgerList.get(i);
                    ledgerManager.readLedgerMetadata(info.ledgerId).whenComplete((metadata, exception) -> {
                        if (exception != null) {
                            LOG.error("Unable to read the ledger: {} information", (Object)info.ledgerId);
                            throw new UncheckedExecutionException(exception);
                        }
                        LOG.info("\tLedgerId:{}\tBookieId:{}\tLedgerSize:{}", new Object[]{info.ledgerId, info.bookieId, ((LedgerMetadata)metadata.getValue()).getLength()});
                    });
                }
            }
            if (ledgerList.size() == 0) {
                LOG.info("\t No Ledger is being recovered.");
            }
            return null;
        });
        return true;
    }

    private static class LedgerRecoverInfo {
        Long ledgerId;
        String bookieId;

        LedgerRecoverInfo(Long ledgerId, String bookieId) {
            this.ledgerId = ledgerId;
            this.bookieId = bookieId;
        }
    }

    public static class QFlags
    extends CliFlags {
        @Parameter(names={"-v", "--verbose"}, description="list recovering detailed ledger info")
        private Boolean verbose = false;

        public QFlags verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }
    }
}

