/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.AbstractMetadataDriver;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerAuditorManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerIdGenerator;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerUnderreplicationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarLedgerManagerFactory
implements LedgerManagerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarLedgerManagerFactory.class);
    private static final int CUR_VERSION = 1;
    private AbstractConfiguration conf;
    private MetadataStoreExtended store;
    private String ledgerRootPath;

    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager layoutManager, int factoryVersion) throws IOException {
        Preconditions.checkArgument((boolean)(layoutManager instanceof PulsarLayoutManager));
        PulsarLayoutManager pulsarLayoutManager = (PulsarLayoutManager)layoutManager;
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.store = pulsarLayoutManager.getStore();
        this.ledgerRootPath = pulsarLayoutManager.getLedgersRootPath();
        return this;
    }

    public void close() throws IOException {
    }

    public int getCurrentVersion() {
        return 1;
    }

    public LedgerIdGenerator newLedgerIdGenerator() {
        return new PulsarLedgerIdGenerator(this.store, this.ledgerRootPath);
    }

    public LedgerManager newLedgerManager() {
        return new PulsarLedgerManager(this.store, this.ledgerRootPath);
    }

    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws ReplicationException.CompatibilityException {
        return new PulsarLedgerUnderreplicationManager(this.conf, this.store, this.ledgerRootPath);
    }

    public LedgerAuditorManager newLedgerAuditorManager() throws IOException, InterruptedException {
        return new PulsarLedgerAuditorManager(this.store, this.ledgerRootPath);
    }

    public void format(AbstractConfiguration<?> abstractConfiguration, LayoutManager layoutManager) throws InterruptedException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndNukeExistingCluster(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, IOException {
        PulsarLedgerManager ledgerManager = new PulsarLedgerManager(this.store, this.ledgerRootPath);
        try {
            List<String> ledgersRootPathChildren;
            List<String> ledgersRootPathChildrenList;
            try {
                ledgersRootPathChildrenList = this.store.getChildren(this.ledgerRootPath).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
            for (String ledgersRootPathChildren2 : ledgersRootPathChildrenList) {
                if (AbstractZkLedgerManager.isSpecialZnode((String)ledgersRootPathChildren2) || ledgerManager.isLedgerParentNode(ledgersRootPathChildren2)) continue;
                log.error("Found unexpected node : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren2, (Object)this.ledgerRootPath);
                boolean bl = false;
                return bl;
            }
            this.format(conf, layoutManager);
            try {
                ledgersRootPathChildren = this.store.getChildren(this.ledgerRootPath).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
            for (String ledgersRootPathChild : ledgersRootPathChildren) {
                if (AbstractZkLedgerManager.isSpecialZnode((String)ledgersRootPathChild)) {
                    try {
                        this.store.deleteRecursive(this.ledgerRootPath + "/" + ledgersRootPathChild).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (ExecutionException | TimeoutException e) {
                        throw new IOException(e);
                    }
                }
                log.error("Found unexpected node : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChild, (Object)this.ledgerRootPath);
                boolean bl = false;
                return bl;
            }
            try {
                this.store.deleteRecursive(this.ledgerRootPath).get(AbstractMetadataDriver.BLOCKING_CALL_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
            log.info("Successfully nuked existing cluster");
            boolean bl = true;
            return bl;
        }
        finally {
            if (Collections.singletonList(ledgerManager).get(0) != null) {
                ledgerManager.close();
            }
        }
    }
}

