/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionBufferInternalStats;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInfo;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckInternalStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.stats.PositionInPendingAckStats;

public interface Transactions {
    public List<TransactionCoordinatorInfo> listTransactionCoordinators() throws PulsarAdminException;

    public CompletableFuture<List<TransactionCoordinatorInfo>> listTransactionCoordinatorsAsync();

    public CompletableFuture<TransactionCoordinatorStats> getCoordinatorStatsByIdAsync(int var1);

    public TransactionCoordinatorStats getCoordinatorStatsById(int var1) throws PulsarAdminException;

    public CompletableFuture<Map<Integer, TransactionCoordinatorStats>> getCoordinatorStatsAsync();

    public Map<Integer, TransactionCoordinatorStats> getCoordinatorStats() throws PulsarAdminException;

    public CompletableFuture<TransactionInBufferStats> getTransactionInBufferStatsAsync(TxnID var1, String var2);

    public TransactionInBufferStats getTransactionInBufferStats(TxnID var1, String var2) throws PulsarAdminException;

    public CompletableFuture<TransactionInPendingAckStats> getTransactionInPendingAckStatsAsync(TxnID var1, String var2, String var3);

    public TransactionInPendingAckStats getTransactionInPendingAckStats(TxnID var1, String var2, String var3) throws PulsarAdminException;

    public CompletableFuture<TransactionMetadata> getTransactionMetadataAsync(TxnID var1);

    public TransactionMetadata getTransactionMetadata(TxnID var1) throws PulsarAdminException;

    public CompletableFuture<TransactionBufferStats> getTransactionBufferStatsAsync(String var1, boolean var2, boolean var3);

    default public CompletableFuture<TransactionBufferStats> getTransactionBufferStatsAsync(String topic, boolean lowWaterMarks) {
        return this.getTransactionBufferStatsAsync(topic, lowWaterMarks, false);
    }

    default public CompletableFuture<TransactionBufferStats> getTransactionBufferStatsAsync(String topic) {
        return this.getTransactionBufferStatsAsync(topic, false, false);
    }

    public TransactionBufferStats getTransactionBufferStats(String var1, boolean var2, boolean var3) throws PulsarAdminException;

    default public TransactionBufferStats getTransactionBufferStats(String topic, boolean lowWaterMarks) throws PulsarAdminException {
        return this.getTransactionBufferStats(topic, lowWaterMarks, false);
    }

    default public TransactionBufferStats getTransactionBufferStats(String topic) throws PulsarAdminException {
        return this.getTransactionBufferStats(topic, false, false);
    }

    public CompletableFuture<TransactionPendingAckStats> getPendingAckStatsAsync(String var1, String var2, boolean var3);

    default public CompletableFuture<TransactionPendingAckStats> getPendingAckStatsAsync(String topic, String subName) {
        return this.getPendingAckStatsAsync(topic, subName, false);
    }

    public TransactionPendingAckStats getPendingAckStats(String var1, String var2, boolean var3) throws PulsarAdminException;

    default public TransactionPendingAckStats getPendingAckStats(String topic, String subName) throws PulsarAdminException {
        return this.getPendingAckStats(topic, subName, false);
    }

    public CompletableFuture<Map<String, TransactionMetadata>> getSlowTransactionsByCoordinatorIdAsync(Integer var1, long var2, TimeUnit var4);

    public Map<String, TransactionMetadata> getSlowTransactionsByCoordinatorId(Integer var1, long var2, TimeUnit var4) throws PulsarAdminException;

    public CompletableFuture<Map<String, TransactionMetadata>> getSlowTransactionsAsync(long var1, TimeUnit var3);

    public Map<String, TransactionMetadata> getSlowTransactions(long var1, TimeUnit var3) throws PulsarAdminException;

    public CompletableFuture<TransactionCoordinatorInternalStats> getCoordinatorInternalStatsAsync(int var1, boolean var2);

    public TransactionCoordinatorInternalStats getCoordinatorInternalStats(int var1, boolean var2) throws PulsarAdminException;

    public CompletableFuture<TransactionPendingAckInternalStats> getPendingAckInternalStatsAsync(String var1, String var2, boolean var3);

    public TransactionPendingAckInternalStats getPendingAckInternalStats(String var1, String var2, boolean var3) throws PulsarAdminException;

    public CompletableFuture<TransactionBufferInternalStats> getTransactionBufferInternalStatsAsync(String var1, boolean var2);

    public TransactionBufferInternalStats getTransactionBufferInternalStats(String var1, boolean var2) throws PulsarAdminException;

    public void scaleTransactionCoordinators(int var1) throws PulsarAdminException;

    public CompletableFuture<Void> scaleTransactionCoordinatorsAsync(int var1);

    public PositionInPendingAckStats getPositionStatsInPendingAck(String var1, String var2, Long var3, Long var4, Integer var5) throws PulsarAdminException;

    public CompletableFuture<PositionInPendingAckStats> getPositionStatsInPendingAckAsync(String var1, String var2, Long var3, Long var4, Integer var5);

    public void abortTransaction(TxnID var1) throws PulsarAdminException;

    public CompletableFuture<Void> abortTransactionAsync(TxnID var1);
}

