/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationParameters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.ExceptionInformation;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.utils.ComponentTypeUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionFilePackage;
import org.apache.pulsar.functions.utils.FunctionMetaDataUtils;
import org.apache.pulsar.functions.utils.SourceConfigUtils;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.apache.pulsar.functions.worker.rest.api.ComponentImpl;
import org.apache.pulsar.functions.worker.service.api.Sources;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcesImpl
extends ComponentImpl
implements Sources<PulsarWorkerService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourcesImpl.class);

    public SourcesImpl(Supplier<PulsarWorkerService> workerServiceSupplier) {
        super(workerServiceSupplier, Function.FunctionDetails.ComponentType.SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSource(String tenant, String namespace, String sourceName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String sourcePkgUrl, SourceConfig sourceConfig, AuthenticationParameters authParams) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (sourceName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Source name is not provided");
        }
        if (sourceConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Source config is not provided");
        }
        this.throwRestExceptionIfUnauthorizedForNamespace(tenant, namespace, sourceName, "register", authParams);
        try {
            this.worker().getBrokerAdmin().tenants().getTenantInfo(tenant);
            String qualifiedNamespace = tenant + "/" + namespace;
            List namespaces = this.worker().getBrokerAdmin().namespaces().getNamespaces(tenant);
            if (namespaces != null && !namespaces.contains(qualifiedNamespace)) {
                String qualifiedNamespaceWithCluster = String.format("%s/%s/%s", tenant, this.worker().getWorkerConfig().getPulsarFunctionsCluster(), namespace);
                if (namespaces != null && !namespaces.contains(qualifiedNamespaceWithCluster)) {
                    log.error("{}/{}/{} Namespace {} does not exist", new Object[]{tenant, namespace, sourceName, namespace});
                    throw new RestException(Response.Status.BAD_REQUEST, "Namespace does not exist");
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException e) {
            log.error("{}/{}/{} Client is not authorized to operate {} on tenant", new Object[]{tenant, namespace, sourceName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        catch (PulsarAdminException.NotFoundException e) {
            log.error("{}/{}/{} Tenant {} does not exist", new Object[]{tenant, namespace, sourceName, tenant});
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant does not exist");
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Issues getting tenant data", new Object[]{tenant, namespace, sourceName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (functionMetaDataManager.containsFunction(tenant, namespace, sourceName)) {
            log.error("{} {}/{}/{} already exists", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s already exists", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName));
        }
        Function.FunctionDetails functionDetails = null;
        boolean isPkgUrlProvided = StringUtils.isNotBlank((CharSequence)sourcePkgUrl);
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            try {
                if (isPkgUrlProvided) {
                    componentPackageFile = this.getPackageFile(this.componentType, sourcePkgUrl);
                    functionDetails = this.validateUpdateRequestParams(tenant, namespace, sourceName, sourceConfig, componentPackageFile);
                } else {
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                    }
                    if (!(FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)(functionDetails = this.validateUpdateRequestParams(tenant, namespace, sourceName, sourceConfig, componentPackageFile))) || componentPackageFile != null && fileDetail != null)) {
                        throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                    }
                }
            }
            catch (Exception e) {
                log.error("Invalid register {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("{} {}/{}/{} cannot be admitted by the runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().setFunctionDetails(functionDetails).setCreateTime(System.currentTimeMillis()).setVersion(0L);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (authParams.getClientAuthenticationDataSource() != null) {
                        try {
                            Optional functionAuthData = functionAuthProvider.cacheAuthData(finalFunctionDetails, authParams.getClientAuthenticationDataSource());
                            functionAuthData.ifPresent(authData -> functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])authData.getData())).build()));
                        }
                        catch (Exception e) {
                            log.error("Error caching authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName, e.getMessage()));
                        }
                    }
                });
            }
            try {
                packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), sourcePkgUrl, fileDetail, componentPackageFile);
            }
            catch (Exception e) {
                log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(null, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (sourcePkgUrl == null || !sourcePkgUrl.startsWith("file"))) {
                componentPackageFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSource(String tenant, String namespace, String sourceName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String sourcePkgUrl, SourceConfig sourceConfig, AuthenticationParameters authParams, UpdateOptionsImpl updateOptions) {
        SourceConfig mergedConfig;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (sourceName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Source name is not provided");
        }
        if (sourceConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Source config is not provided");
        }
        this.throwRestExceptionIfUnauthorizedForNamespace(tenant, namespace, sourceName, "update", authParams);
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, sourceName)) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName));
        }
        Function.FunctionMetaData existingComponent = functionMetaDataManager.getFunctionMetaData(tenant, namespace, sourceName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)existingComponent.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, sourceName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName));
        }
        SourceConfig existingSourceConfig = SourceConfigUtils.convertFromDetails((Function.FunctionDetails)existingComponent.getFunctionDetails());
        sourceConfig.setTenant(tenant);
        sourceConfig.setNamespace(namespace);
        sourceConfig.setName(sourceName);
        try {
            mergedConfig = SourceConfigUtils.validateUpdate((SourceConfig)existingSourceConfig, (SourceConfig)sourceConfig);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        if (existingSourceConfig.equals((Object)mergedConfig) && StringUtils.isBlank((CharSequence)sourcePkgUrl) && uploadedInputStream == null && (updateOptions == null || !updateOptions.isUpdateAuthData())) {
            log.error("{}/{}/{} Update contains no changes", new Object[]{tenant, namespace, sourceName});
            throw new RestException(Response.Status.BAD_REQUEST, "Update contains no change");
        }
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            Function.FunctionDetails functionDetails;
            try {
                componentPackageFile = this.getPackageFile(this.componentType, sourcePkgUrl, existingComponent.getPackageLocation().getPackagePath(), uploadedInputStream);
                functionDetails = this.validateUpdateRequestParams(tenant, namespace, sourceName, mergedConfig, componentPackageFile);
                if (existingComponent.getPackageLocation().getPackagePath().startsWith("builtin") && !FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)functionDetails) && (componentPackageFile == null || fileDetail == null)) {
                    throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                }
            }
            catch (Exception e) {
                log.error("Invalid update {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("Updated {} {}/{}/{} cannot be submitted to runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().mergeFrom(existingComponent).setFunctionDetails(functionDetails);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (authParams.getClientAuthenticationDataSource() != null && updateOptions != null && updateOptions.isUpdateAuthData()) {
                        Optional<Object> existingFunctionAuthData = Optional.empty();
                        if (functionMetaDataBuilder.hasFunctionAuthSpec()) {
                            existingFunctionAuthData = Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(functionMetaDataBuilder.getFunctionAuthSpec())));
                        }
                        try {
                            Optional newFunctionAuthData = functionAuthProvider.updateAuthData(finalFunctionDetails, existingFunctionAuthData, authParams.getClientAuthenticationDataSource());
                            if (newFunctionAuthData.isPresent()) {
                                functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])((FunctionAuthData)newFunctionAuthData.get()).getData())).build());
                            } else {
                                functionMetaDataBuilder.clearFunctionAuthSpec();
                            }
                        }
                        catch (Exception e) {
                            log.error("Error updating authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sourceName, e.getMessage()));
                        }
                    }
                });
            }
            if (StringUtils.isNotBlank((CharSequence)sourcePkgUrl) || uploadedInputStream != null) {
                Function.FunctionMetaData metaData = functionMetaDataBuilder.build();
                metaData = FunctionMetaDataUtils.incrMetadataVersion((Function.FunctionMetaData)metaData, (Function.FunctionMetaData)metaData);
                try {
                    packageLocationMetaDataBuilder = this.getFunctionPackageLocation(metaData, sourcePkgUrl, fileDetail, componentPackageFile);
                }
                catch (Exception e) {
                    log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sourceName, e});
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            } else {
                packageLocationMetaDataBuilder = Function.PackageLocationMetaData.newBuilder().mergeFrom(existingComponent.getPackageLocation());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(existingComponent, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (sourcePkgUrl != null && !sourcePkgUrl.startsWith("file") || uploadedInputStream != null)) {
                componentPackageFile.delete();
            }
        }
    }

    @Override
    public SourceStatus getSourceStatus(String tenant, String namespace, String componentName, URI uri, AuthenticationParameters authParams) {
        SourceStatus sourceStatus;
        this.componentStatusRequestValidate(tenant, namespace, componentName, authParams);
        try {
            sourceStatus = (SourceStatus)new GetSourceStatus().getComponentStatus(tenant, namespace, componentName, uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return sourceStatus;
    }

    @Override
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceInstanceStatus(String tenant, String namespace, String sourceName, String instanceId, URI uri, AuthenticationParameters authParams) {
        SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData;
        this.componentInstanceStatusRequestValidate(tenant, namespace, sourceName, Integer.parseInt(instanceId), authParams);
        try {
            sourceInstanceStatusData = (SourceStatus.SourceInstanceStatus.SourceInstanceStatusData)new GetSourceStatus().getComponentInstanceStatus(tenant, namespace, sourceName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, sourceName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return sourceInstanceStatusData;
    }

    @Override
    public SourceConfig getSourceInfo(String tenant, String namespace, String componentName, AuthenticationParameters authParams) {
        this.componentStatusRequestValidate(tenant, namespace, componentName, authParams);
        Function.FunctionMetaData functionMetaData = this.worker().getFunctionMetaDataManager().getFunctionMetaData(tenant, namespace, componentName);
        return SourceConfigUtils.convertFromDetails((Function.FunctionDetails)functionMetaData.getFunctionDetails());
    }

    @Override
    public List<ConnectorDefinition> getSourceList() {
        List<ConnectorDefinition> connectorDefinitions = this.getListOfConnectors();
        ArrayList<ConnectorDefinition> retval = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((CharSequence)connectorDefinition.getSourceClass())) continue;
            retval.add(connectorDefinition);
        }
        return retval;
    }

    @Override
    public List<ConfigFieldDefinition> getSourceConfigDefinition(String name) {
        List retval;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if ((retval = this.worker().getConnectorsManager().getSourceConfigDefinition(name)) == null) {
            throw new RestException(Response.Status.NOT_FOUND, "builtin source does not exist");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function.FunctionDetails validateUpdateRequestParams(String tenant, String namespace, String sourceName, SourceConfig sourceConfig, File sourcePackageFile) {
        String archive;
        sourceConfig.setTenant(tenant);
        sourceConfig.setNamespace(namespace);
        sourceConfig.setName(sourceName);
        Utils.inferMissingArguments((SourceConfig)sourceConfig);
        FunctionFilePackage connectorFunctionPackage = null;
        if (!StringUtils.isEmpty((CharSequence)sourceConfig.getArchive()) && (archive = sourceConfig.getArchive()).startsWith("builtin")) {
            archive = archive.replaceFirst("^builtin://", "");
            Connector connector = this.worker().getConnectorsManager().getConnector(archive);
            if (connector == null) {
                throw new IllegalArgumentException("Built-in source is not available");
            }
            connectorFunctionPackage = connector.getConnectorFunctionPackage();
        }
        boolean shouldCloseFunctionPackage = false;
        try {
            WorkerConfig workerConfig = this.worker().getWorkerConfig();
            if (connectorFunctionPackage == null && sourcePackageFile != null) {
                connectorFunctionPackage = new FunctionFilePackage(sourcePackageFile, workerConfig.getNarExtractionDirectory(), workerConfig.getEnableClassloadingOfExternalFiles().booleanValue(), ConnectorDefinition.class);
                shouldCloseFunctionPackage = true;
            }
            if (connectorFunctionPackage == null) {
                throw new IllegalArgumentException("Source package is not provided");
            }
            SourceConfigUtils.ExtractedSourceDetails sourceDetails = SourceConfigUtils.validateAndExtractDetails((SourceConfig)sourceConfig, connectorFunctionPackage, (boolean)workerConfig.getValidateConnectorConfig());
            Function.FunctionDetails functionDetails = SourceConfigUtils.convert((SourceConfig)sourceConfig, (SourceConfigUtils.ExtractedSourceDetails)sourceDetails);
            return functionDetails;
        }
        finally {
            if (shouldCloseFunctionPackage && connectorFunctionPackage instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)connectorFunctionPackage).close();
                }
                catch (Exception e) {
                    log.error("Failed to connector function file", (Throwable)e);
                }
            }
        }
    }

    private class GetSourceStatus
    extends ComponentImpl.GetStatus<SourceStatus, SourceStatus.SourceInstanceStatus.SourceInstanceStatusData> {
        private GetSourceStatus() {
        }

        @Override
        public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData notScheduledInstance() {
            SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = new SourceStatus.SourceInstanceStatus.SourceInstanceStatusData();
            sourceInstanceStatusData.setRunning(false);
            sourceInstanceStatusData.setError("Source has not been scheduled");
            return sourceInstanceStatusData;
        }

        @Override
        public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData fromFunctionStatusProto(InstanceCommunication.FunctionStatus status, String assignedWorkerId) {
            ExceptionInformation exceptionInformation;
            SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = new SourceStatus.SourceInstanceStatus.SourceInstanceStatusData();
            sourceInstanceStatusData.setRunning(status.getRunning());
            sourceInstanceStatusData.setError(status.getFailureException());
            sourceInstanceStatusData.setNumRestarts(status.getNumRestarts());
            sourceInstanceStatusData.setNumReceivedFromSource(status.getNumReceived());
            sourceInstanceStatusData.setNumSourceExceptions(status.getNumSourceExceptions());
            LinkedList<ExceptionInformation> sourceExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSourceExceptionsList()) {
                ExceptionInformation exceptionInformation2 = new ExceptionInformation();
                exceptionInformation2.setTimestampMs(exceptionEntry.getMsSinceEpoch());
                exceptionInformation2.setExceptionString(exceptionEntry.getExceptionString());
                sourceExceptionInformationList.add(exceptionInformation2);
            }
            sourceInstanceStatusData.setLatestSourceExceptions(sourceExceptionInformationList);
            sourceInstanceStatusData.setNumSystemExceptions(status.getNumSystemExceptions() + status.getNumUserExceptions() + status.getNumSinkExceptions());
            LinkedList<ExceptionInformation> systemExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestUserExceptionsList()) {
                exceptionInformation = new ExceptionInformation();
                exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
                exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSystemExceptionsList()) {
                exceptionInformation = new ExceptionInformation();
                exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
                exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSinkExceptionsList()) {
                exceptionInformation = new ExceptionInformation();
                exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
                exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
                systemExceptionInformationList.add(exceptionInformation);
            }
            sourceInstanceStatusData.setLatestSystemExceptions(systemExceptionInformationList);
            sourceInstanceStatusData.setNumWritten(status.getNumSuccessfullyProcessed());
            sourceInstanceStatusData.setLastReceivedTime(status.getLastInvocationTime());
            sourceInstanceStatusData.setWorkerId(assignedWorkerId);
            return sourceInstanceStatusData;
        }

        @Override
        public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData notRunning(String assignedWorkerId, String error) {
            SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = new SourceStatus.SourceInstanceStatus.SourceInstanceStatusData();
            sourceInstanceStatusData.setRunning(false);
            if (error != null) {
                sourceInstanceStatusData.setError(error);
            }
            sourceInstanceStatusData.setWorkerId(assignedWorkerId);
            return sourceInstanceStatusData;
        }

        @Override
        public SourceStatus getStatus(String tenant, String namespace, String name, Collection<Function.Assignment> assignments, URI uri) throws PulsarAdminException {
            SourceStatus sourceStatus = new SourceStatus();
            for (Function.Assignment assignment : assignments) {
                boolean isOwner = SourcesImpl.this.worker().getWorkerConfig().getWorkerId().equals(assignment.getWorkerId());
                SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = isOwner ? (SourceStatus.SourceInstanceStatus.SourceInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, assignment.getInstance().getInstanceId(), null) : SourcesImpl.this.worker().getFunctionAdmin().sources().getSourceStatus(assignment.getInstance().getFunctionMetaData().getFunctionDetails().getTenant(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getNamespace(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getName(), assignment.getInstance().getInstanceId());
                SourceStatus.SourceInstanceStatus instanceStatus = new SourceStatus.SourceInstanceStatus();
                instanceStatus.setInstanceId(assignment.getInstance().getInstanceId());
                instanceStatus.setStatus(sourceInstanceStatusData);
                sourceStatus.addInstance(instanceStatus);
            }
            sourceStatus.setNumInstances(sourceStatus.instances.size());
            sourceStatus.getInstances().forEach(sourceInstanceStatus -> {
                if (sourceInstanceStatus.getStatus().isRunning()) {
                    ++sourceStatus.numRunning;
                }
            });
            return sourceStatus;
        }

        @Override
        public SourceStatus getStatusExternal(String tenant, String namespace, String name, int parallelism) {
            SourceStatus sinkStatus = new SourceStatus();
            for (int i = 0; i < parallelism; ++i) {
                SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = (SourceStatus.SourceInstanceStatus.SourceInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, i, null);
                SourceStatus.SourceInstanceStatus sourceInstanceStatus2 = new SourceStatus.SourceInstanceStatus();
                sourceInstanceStatus2.setInstanceId(i);
                sourceInstanceStatus2.setStatus(sourceInstanceStatusData);
                sinkStatus.addInstance(sourceInstanceStatus2);
            }
            sinkStatus.setNumInstances(sinkStatus.instances.size());
            sinkStatus.getInstances().forEach(sourceInstanceStatus -> {
                if (sourceInstanceStatus.getStatus().isRunning()) {
                    ++sinkStatus.numRunning;
                }
            });
            return sinkStatus;
        }

        @Override
        public SourceStatus emptyStatus(int parallelism) {
            SourceStatus sourceStatus = new SourceStatus();
            sourceStatus.setNumInstances(parallelism);
            sourceStatus.setNumRunning(0);
            for (int i = 0; i < parallelism; ++i) {
                SourceStatus.SourceInstanceStatus sourceInstanceStatus = new SourceStatus.SourceInstanceStatus();
                sourceInstanceStatus.setInstanceId(i);
                SourceStatus.SourceInstanceStatus.SourceInstanceStatusData sourceInstanceStatusData = new SourceStatus.SourceInstanceStatus.SourceInstanceStatusData();
                sourceInstanceStatusData.setRunning(false);
                sourceInstanceStatusData.setError("Source has not been scheduled");
                sourceInstanceStatus.setStatus(sourceInstanceStatusData);
                sourceStatus.addInstance(sourceInstanceStatus);
            }
            return sourceStatus;
        }
    }
}

